/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.compat.chisel.builder.base;

import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.TooltipHelpers;
import com.leclowndu93150.chisel.item.ItemChisel;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.ModConfigSpec;

public abstract class BaseAbilityChisel
extends ItemChisel
implements ToggleableTool {
    protected int index;
    protected final EnumSet<Ability> abilities = EnumSet.noneOf(Ability.class);
    protected final Map<Ability, AbilityParams> abilityParams = new EnumMap<Ability, AbilityParams>(Ability.class);
    private List<Item> repairItems = List.of((Item)Registration.FerricoreIngot.get(), (Item)Registration.BlazegoldIngot.get());

    public BaseAbilityChisel(ItemChisel.ChiselType t, Item.Properties p, int index) {
        super(t, p.stacksTo(1));
        this.index = index;
    }

    public BaseAbilityChisel(ItemChisel.ChiselType t, Item.Properties p) {
        this(t, p, -1);
    }

    public boolean isValidRepairItem(ItemStack damagedItem, ItemStack repairMaterial) {
        return this.index == -1 ? false : (this.repairItems.contains(repairMaterial.getItem()) ? this.repairItems.indexOf(repairMaterial.getItem()) == this.index : super.isValidRepairItem(damagedItem, repairMaterial));
    }

    public EnumSet<Ability> getAllAbilities() {
        return this.abilities;
    }

    public EnumSet<Ability> getAbilities() {
        return this.abilities.stream().filter(a -> (Boolean)((ModConfigSpec.BooleanValue)Config.AVAILABLE_ABILITY_MAP.get(a)).get()).collect(Collectors.toCollection(() -> EnumSet.noneOf(Ability.class)));
    }

    public Map<Ability, AbilityParams> getAbilityParamsMap() {
        return this.abilityParams;
    }

    protected abstract boolean enableToolAbilityTip();

    public void appendHoverText(ItemStack s, Item.TooltipContext c, List<Component> t, TooltipFlag f) {
        super.appendHoverText(s, c, t, f);
        if (this.enableToolAbilityTip()) {
            this.toolAbilityTips(s, c, t);
        }
    }

    public void toolAbilityTips(ItemStack s, Item.TooltipContext c, List<Component> t) {
        if (c.level() != null) {
            TooltipHelpers.appendToolEnabled((ItemStack)s, t);
            if (Screen.hasShiftDown()) {
                TooltipHelpers.appendAbilityList((ItemStack)s, t);
            } else {
                TooltipHelpers.appendShiftForInfo((ItemStack)s, t);
            }
        }
    }
}

