/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.client.type.paradoxMixer;

import com.devdyna.justdynathings.registry.builders.paradox_mixer.ParadoxMixerBE;
import com.devdyna.justdynathings.registry.types.zBlocks;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public class ParadoxMixerRender
implements BlockEntityRenderer<ParadoxMixerBE> {
    private final Minecraft mc = Minecraft.getInstance();

    public ParadoxMixerRender(BlockEntityRendererProvider.Context context) {
    }

    public void render(ParadoxMixerBE be, float tickDelta, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        boolean active = false;
        try {
            active = (Boolean)be.getLevel().getBlockState(be.getBlockPos()).getValue((Property)zProperties.GOO_ALIVE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!active) {
            return;
        }
        BlockPos pos = be.getBlockPos();
        double t = be.getLevel() != null ? (double)((float)be.getLevel().getGameTime() + tickDelta) : 0.0;
        long seed = pos.asLong();
        double offsetX = (double)(seed & 0xFFFFL) / 65535.0 * Math.PI * 2.0;
        double offsetY = (double)(seed >> 16 & 0xFFFFL) / 65535.0 * Math.PI * 2.0;
        double offsetZ = (double)(seed >> 32 & 0xFFFFL) / 65535.0 * Math.PI * 2.0;
        float rotX = (float)(Math.sin(t * 0.05 + offsetX) * 25.0);
        float rotY = (float)(Math.sin(t * 0.045 + offsetY) * 25.0);
        float rotZ = (float)(Math.cos(t * 0.055 + offsetZ) * 25.0);
        float bob = (float)(Math.sin(t * 0.1 + offsetY) * 0.1);
        float scale = 0.5f + (float)(Math.sin(t * 0.1 + offsetZ) * 0.05);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.55 + (double)bob, 0.5);
        poseStack.mulPose(Axis.XP.rotationDegrees(rotX));
        poseStack.mulPose(Axis.YP.rotationDegrees(rotY));
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotZ));
        poseStack.scale(scale, scale, scale);
        poseStack.translate(-0.5, -0.55, -0.5);
        this.mc.getBlockRenderer().renderSingleBlock(((Block)zBlocks.PARADOX_RENDER.get()).defaultBlockState(), poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

