/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.util;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;

public class FakePlayerHandler {
    private static final GameProfile DEFAULT_PROFILE = new GameProfile(UUID.fromString("12345678-1234-1234-1234-123456789012"), "[MobFlowUtilities]");

    private static FakePlayer getDefault(ServerLevel level) {
        return FakePlayerFactory.get((ServerLevel)level, (GameProfile)DEFAULT_PROFILE);
    }

    private static FakePlayer get(ServerLevel level, @Nullable UUID placer) {
        FakePlayer fakePlayer = placer == null ? FakePlayerHandler.getDefault(level) : FakePlayerFactory.get((ServerLevel)level, (GameProfile)new GameProfile(placer, Component.translatable((String)"fakeplayer.mobflowutilities.damage_pad").getString()));
        fakePlayer.getPersistentData().putBoolean("mobflowutilities", true);
        fakePlayer.setInvisible(true);
        fakePlayer.setInvulnerable(true);
        return fakePlayer;
    }

    public static WeakReference<FakePlayer> get(WeakReference<FakePlayer> previous, ServerLevel level, @Nullable UUID placer, BlockPos pos) {
        FakePlayer fakePlayer = (FakePlayer)previous.get();
        if (fakePlayer == null) {
            fakePlayer = FakePlayerHandler.get(level, placer);
            fakePlayer.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            return new WeakReference<FakePlayer>(fakePlayer);
        }
        fakePlayer.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        return previous;
    }

    public static boolean isMobflowutilitiesFakePlayer(FakePlayer fakePlayer) {
        return fakePlayer.getPersistentData().contains("mobflowutilities");
    }
}

