/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.recipe;

import com.misterd.mobflowutilities.component.MFUDataComponents;
import com.misterd.mobflowutilities.item.MFUItems;
import com.misterd.mobflowutilities.recipe.MFURecipeSerializers;
import com.misterd.mobflowutilities.util.GeneticHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GeneticRecipe
extends ShapelessRecipe {
    public GeneticRecipe(String group) {
        super(group, CraftingBookCategory.MISC, new ItemStack((ItemLike)Items.EGG), GeneticRecipe.createIngredients());
    }

    private static NonNullList<Ingredient> createIngredients() {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MFUItems.GENE_SAMPLE_VIAL.get()}));
        ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MFUItems.INCUBATION_ORB.get()}));
        ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.EMERALD}));
        return ingredients;
    }

    public boolean matches(CraftingInput input, Level level) {
        boolean hasGeneSample = false;
        boolean hasPulseCore = false;
        boolean hasEmerald = false;
        ResourceLocation entityDNA = null;
        int itemCount = 0;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            ++itemCount;
            if (stack.getItem() == MFUItems.GENE_SAMPLE_VIAL.get()) {
                if (hasGeneSample) {
                    return false;
                }
                entityDNA = (ResourceLocation)stack.get((DataComponentType)MFUDataComponents.ENTITY_DNA.get());
                if (entityDNA == null) {
                    return false;
                }
                hasGeneSample = true;
                continue;
            }
            if (stack.getItem() == MFUItems.INCUBATION_ORB.get()) {
                if (hasPulseCore) {
                    return false;
                }
                hasPulseCore = true;
                continue;
            }
            if (stack.getItem() != Items.EMERALD) {
                return false;
            }
            if (hasEmerald) {
                return false;
            }
            hasEmerald = true;
        }
        if (itemCount == 3 && hasGeneSample && hasPulseCore && hasEmerald) {
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityDNA);
            boolean canCollect = GeneticHelper.canCollectDNA(entityType);
            return canCollect;
        }
        return false;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        for (int i = 0; i < input.size(); ++i) {
            EntityType entityType;
            SpawnEggItem spawnEgg;
            ItemStack stack = input.getItem(i);
            if (stack.getItem() != MFUItems.GENE_SAMPLE_VIAL.get()) continue;
            ResourceLocation entityDNA = (ResourceLocation)stack.get((DataComponentType)MFUDataComponents.ENTITY_DNA.get());
            if (entityDNA == null || (spawnEgg = GeneticHelper.getSpawnEgg(entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityDNA))) == null) break;
            return new ItemStack((ItemLike)spawnEgg);
        }
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return MFURecipeSerializers.GENETIC_RECIPE.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<GeneticRecipe> {
        public static final MapCodec<GeneticRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapelessRecipe::getGroup)).apply((Applicative)instance, GeneticRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GeneticRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<GeneticRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GeneticRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, GeneticRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
        }

        public static GeneticRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            return new GeneticRecipe(group);
        }
    }
}

