/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.network;

import com.misterd.mobflowutilities.entity.custom.CollectorBlockEntity;
import com.misterd.mobflowutilities.gui.custom.VoidFilterMenu;
import com.misterd.mobflowutilities.item.custom.VoidFilterItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OpenFilterPacket(BlockPos collectorPos, int filterSlotIndex) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenFilterPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"open_filter"));
    public static final StreamCodec<ByteBuf, OpenFilterPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, OpenFilterPacket::collectorPos, (StreamCodec)ByteBufCodecs.INT, OpenFilterPacket::filterSlotIndex, OpenFilterPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(OpenFilterPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer;
            BlockEntity blockEntity;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (blockEntity = (serverPlayer = (ServerPlayer)patt0$temp).level().getBlockEntity(packet.collectorPos)) instanceof CollectorBlockEntity) {
                CollectorBlockEntity collector = (CollectorBlockEntity)blockEntity;
                ItemStack filterStack = collector.moduleSlots.getStackInSlot(packet.filterSlotIndex);
                if (filterStack.getItem() instanceof VoidFilterItem) {
                    serverPlayer.openMenu(VoidFilterMenu.createForCollectorFilter((Component)Component.translatable((String)"gui.mobflowutilities.void_filter"), packet.collectorPos, packet.filterSlotIndex));
                }
            }
        });
    }
}

