/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.network;

import com.misterd.mobflowutilities.entity.custom.CollectorBlockEntity;
import com.misterd.mobflowutilities.entity.custom.GenesisChamberBlockEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ConfigPacket(ConfigTarget target, BlockPos pos, ConfigType configType, int intValue, boolean boolValue) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ConfigPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"mod_config"));
    public static final StreamCodec<FriendlyByteBuf, ConfigPacket> STREAM_CODEC = StreamCodec.composite(ConfigTarget.STREAM_CODEC, ConfigPacket::target, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), packet -> Optional.ofNullable(packet.pos()), ConfigType.STREAM_CODEC, ConfigPacket::configType, (StreamCodec)ByteBufCodecs.INT, ConfigPacket::intValue, (StreamCodec)ByteBufCodecs.BOOL, ConfigPacket::boolValue, (target, posOpt, configType, intValue, boolValue) -> new ConfigPacket((ConfigTarget)((Object)target), posOpt.orElse(null), (ConfigType)((Object)configType), (int)intValue, (boolean)boolValue));

    public CustomPacketPayload.Type<ConfigPacket> type() {
        return TYPE;
    }

    public static void handle(ConfigPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            switch (packet.target().ordinal()) {
                case 0: {
                    ConfigPacket.handleCollectorConfig(packet, serverPlayer);
                    break;
                }
                case 1: {
                    ConfigPacket.handleGenesisChamberConfig(packet, serverPlayer);
                }
            }
        });
    }

    private static void handleCollectorConfig(ConfigPacket packet, ServerPlayer player) {
        BlockPos pos = packet.pos();
        if (pos == null) {
            return;
        }
        ServerLevel level = player.serverLevel();
        if (player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) > 64.0) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CollectorBlockEntity)) {
            return;
        }
        CollectorBlockEntity collector = (CollectorBlockEntity)blockEntity;
        switch (packet.configType().ordinal()) {
            case 0: {
                collector.setXpCollectionEnabled(packet.boolValue());
                break;
            }
            case 1: {
                collector.setDownUpOffset(packet.intValue());
                break;
            }
            case 2: {
                collector.setNorthSouthOffset(packet.intValue());
                break;
            }
            case 3: {
                collector.setEastWestOffset(packet.intValue());
                break;
            }
        }
        level.sendBlockUpdated(pos, level.getBlockState(pos), level.getBlockState(pos), 3);
    }

    private static void handleGenesisChamberConfig(ConfigPacket packet, ServerPlayer player) {
        BlockPos pos = packet.pos();
        if (pos == null) {
            return;
        }
        ServerLevel level = player.serverLevel();
        if (player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) > 64.0) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof GenesisChamberBlockEntity)) {
            return;
        }
        GenesisChamberBlockEntity genesisChamber = (GenesisChamberBlockEntity)blockEntity;
        switch (packet.configType().ordinal()) {
            case 10: {
                genesisChamber.setDownUpOffset(packet.intValue());
                break;
            }
            case 11: {
                genesisChamber.setNorthSouthOffset(packet.intValue());
                break;
            }
            case 12: {
                genesisChamber.setEastWestOffset(packet.intValue());
                break;
            }
            case 13: {
                genesisChamber.setRequiresRedstone(packet.boolValue());
                break;
            }
        }
        level.sendBlockUpdated(pos, level.getBlockState(pos), level.getBlockState(pos), 3);
        level.sendBlockUpdated(pos, level.getBlockState(pos), level.getBlockState(pos), 3);
    }

    public static enum ConfigTarget {
        COLLECTOR_BLOCK,
        GENESIS_CHAMBER_BLOCK;

        public static final StreamCodec<FriendlyByteBuf, ConfigTarget> STREAM_CODEC;

        static {
            STREAM_CODEC = StreamCodec.of((buf, target) -> buf.writeEnum((Enum)target), buf -> (ConfigTarget)buf.readEnum(ConfigTarget.class));
        }
    }

    public static enum ConfigType {
        COLLECTOR_XP_COLLECTION_TOGGLE,
        COLLECTOR_DOWN_UP_OFFSET,
        COLLECTOR_NORTH_SOUTH_OFFSET,
        COLLECTOR_EAST_WEST_OFFSET,
        COLLECTOR_TOP_SIDE,
        COLLECTOR_EAST_SIDE,
        COLLECTOR_FRONT_SIDE,
        COLLECTOR_WEST_SIDE,
        COLLECTOR_BOTTOM_SIDE,
        COLLECTOR_BACK_SIDE,
        GENESIS_CHAMBER_DOWN_UP_OFFSET,
        GENESIS_CHAMBER_NORTH_SOUTH_OFFSET,
        GENESIS_CHAMBER_EAST_WEST_OFFSET,
        GENESIS_CHAMBER_REDSTONE_MODE;

        public static final StreamCodec<FriendlyByteBuf, ConfigType> STREAM_CODEC;

        static {
            STREAM_CODEC = StreamCodec.of((buf, type) -> buf.writeEnum((Enum)type), buf -> (ConfigType)buf.readEnum(ConfigType.class));
        }
    }
}

