/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.network;

import com.misterd.mobflowutilities.entity.custom.CollectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CollectorXpPacket(BlockPos pos, XpAction action, int amount) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CollectorXpPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"collector_xp"));
    public static final StreamCodec<FriendlyByteBuf, CollectorXpPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, CollectorXpPacket::pos, XpAction.STREAM_CODEC, CollectorXpPacket::action, (StreamCodec)ByteBufCodecs.INT, CollectorXpPacket::amount, CollectorXpPacket::new);

    public CustomPacketPayload.Type<CollectorXpPacket> type() {
        return TYPE;
    }

    public static void handle(CollectorXpPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = serverPlayer.level().getBlockEntity(packet.pos());
            if (!(blockEntity instanceof CollectorBlockEntity)) {
                return;
            }
            CollectorBlockEntity collector = (CollectorBlockEntity)blockEntity;
            switch (packet.action().ordinal()) {
                case 0: {
                    int storedXp = collector.getStoredXP();
                    int depositAmount = Math.min(packet.amount(), storedXp);
                    if (depositAmount <= 0) break;
                    collector.setStoredXP(storedXp - depositAmount);
                    serverPlayer.giveExperiencePoints(depositAmount);
                    break;
                }
                case 1: {
                    int storedXp = serverPlayer.totalExperience;
                    int depositAmount = Math.min(packet.amount(), storedXp);
                    if (depositAmount <= 0) break;
                    serverPlayer.giveExperiencePoints(-depositAmount);
                    collector.setStoredXP(collector.getStoredXP() + depositAmount);
                }
            }
        });
    }

    public static enum XpAction {
        WITHDRAW,
        DEPOSIT;

        public static final StreamCodec<FriendlyByteBuf, XpAction> STREAM_CODEC;

        static {
            STREAM_CODEC = StreamCodec.of((buf, action) -> buf.writeEnum((Enum)action), buf -> (XpAction)buf.readEnum(XpAction.class));
        }
    }
}

