/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.item.custom;

import com.misterd.mobflowutilities.block.custom.ControllerBlock;
import com.misterd.mobflowutilities.block.custom.DamagePadBlock;
import com.misterd.mobflowutilities.component.MFUDataComponents;
import com.misterd.mobflowutilities.component.custom.PadWrenchData;
import com.misterd.mobflowutilities.entity.custom.ControllerBlockEntity;
import com.misterd.mobflowutilities.entity.custom.DamagePadBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PadWrenchItem
extends Item {
    public PadWrenchItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.toggleOperationMode(stack, player);
        } else {
            this.toggleSelectionMode(stack, player);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockState state = level.getBlockState(pos);
        if (player == null) {
            return InteractionResult.FAIL;
        }
        PadWrenchData data = (PadWrenchData)stack.getOrDefault((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)PadWrenchData.DEFAULT);
        if (state.getBlock() instanceof ControllerBlock) {
            this.selectController(stack, pos, player);
            return InteractionResult.SUCCESS;
        }
        if (state.getBlock() instanceof DamagePadBlock) {
            if (data.selectionMode() == PadWrenchData.SelectionMode.SINGLE) {
                this.handleSinglePadAction(level, pos, stack, player);
            } else {
                this.handleMultiPadAction(level, pos, stack, player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void toggleOperationMode(ItemStack stack, Player player) {
        PadWrenchData currentData = (PadWrenchData)stack.getOrDefault((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)PadWrenchData.DEFAULT);
        PadWrenchData.OperationMode newMode = currentData.operationMode() == PadWrenchData.OperationMode.ADD ? PadWrenchData.OperationMode.REMOVE : PadWrenchData.OperationMode.ADD;
        PadWrenchData newData = currentData.withOperationMode(newMode);
        stack.set((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)newData);
        MutableComponent message = newMode == PadWrenchData.OperationMode.ADD ? Component.translatable((String)"item.mobflowutilities.pad_wrench.mode.add") : Component.translatable((String)"item.mobflowutilities.pad_wrench.mode.remove");
        player.displayClientMessage((Component)message, true);
    }

    private void toggleSelectionMode(ItemStack stack, Player player) {
        PadWrenchData currentData = (PadWrenchData)stack.getOrDefault((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)PadWrenchData.DEFAULT);
        PadWrenchData.SelectionMode newMode = currentData.selectionMode() == PadWrenchData.SelectionMode.SINGLE ? PadWrenchData.SelectionMode.MULTI : PadWrenchData.SelectionMode.SINGLE;
        PadWrenchData newData = currentData.withSelectionMode(newMode);
        stack.set((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)newData);
        MutableComponent message = newMode == PadWrenchData.SelectionMode.SINGLE ? Component.translatable((String)"item.mobflowutilities.pad_wrench.selection.single") : Component.translatable((String)"item.mobflowutilities.pad_wrench.selection.multi");
        player.displayClientMessage((Component)message, true);
    }

    private void selectController(ItemStack stack, BlockPos controllerPos, Player player) {
        PadWrenchData currentData = (PadWrenchData)stack.getOrDefault((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)PadWrenchData.DEFAULT);
        PadWrenchData newData = currentData.withSelectedController(controllerPos);
        stack.set((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)newData);
        MutableComponent message = Component.translatable((String)"item.mobflowutilities.pad_wrench.controller.selected", (Object[])new Object[]{controllerPos.getX(), controllerPos.getY(), controllerPos.getZ()});
        player.displayClientMessage((Component)message, true);
    }

    private void handleSinglePadAction(Level level, BlockPos padPos, ItemStack stack, Player player) {
        PadWrenchData data = (PadWrenchData)stack.getOrDefault((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)PadWrenchData.DEFAULT);
        if (data.selectedController() == null) {
            MutableComponent message = Component.translatable((String)"item.mobflowutilities.pad_wrench.error.no_controller");
            player.displayClientMessage((Component)message, true);
            return;
        }
        BlockEntity be = level.getBlockEntity(padPos);
        if (!(be instanceof DamagePadBlockEntity)) {
            return;
        }
        DamagePadBlockEntity padEntity = (DamagePadBlockEntity)be;
        if (data.operationMode() == PadWrenchData.OperationMode.ADD) {
            padEntity.setControllerPos(data.selectedController());
            BlockEntity controllerBE = level.getBlockEntity(data.selectedController());
            if (controllerBE instanceof ControllerBlockEntity) {
                ControllerBlockEntity controller = (ControllerBlockEntity)controllerBE;
                controller.addPad(padPos);
            }
            MutableComponent message = Component.translatable((String)"item.mobflowutilities.pad_wrench.pad.linked");
            player.displayClientMessage((Component)message, true);
        } else {
            BlockEntity oldControllerBE;
            BlockPos oldControllerPos = padEntity.getControllerPos();
            padEntity.clearControllerPos();
            if (oldControllerPos != null && (oldControllerBE = level.getBlockEntity(oldControllerPos)) instanceof ControllerBlockEntity) {
                ControllerBlockEntity oldController = (ControllerBlockEntity)oldControllerBE;
                oldController.removePad(padPos);
            }
            MutableComponent message = Component.translatable((String)"item.mobflowutilities.pad_wrench.pad.unlinked");
            player.displayClientMessage((Component)message, true);
        }
    }

    private void handleMultiPadAction(Level level, BlockPos padPos, ItemStack stack, Player player) {
        PadWrenchData data = (PadWrenchData)stack.getOrDefault((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)PadWrenchData.DEFAULT);
        if (!player.isShiftKeyDown()) {
            return;
        }
        if (data.firstMultiPos() == null) {
            PadWrenchData newData = data.withFirstMultiPos(padPos);
            stack.set((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)newData);
            MutableComponent message = Component.translatable((String)"item.mobflowutilities.pad_wrench.multi.start", (Object[])new Object[]{padPos.getX(), padPos.getY(), padPos.getZ()});
            player.displayClientMessage((Component)message, true);
        } else {
            this.processMultiSelection(level, data.firstMultiPos(), padPos, stack, player);
            PadWrenchData newData = data.withFirstMultiPos(null);
            stack.set((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)newData);
        }
    }

    private void processMultiSelection(Level level, BlockPos pos1, BlockPos pos2, ItemStack stack, Player player) {
        BlockEntity be;
        PadWrenchData data = (PadWrenchData)stack.getOrDefault((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)PadWrenchData.DEFAULT);
        if (data.selectedController() == null && data.operationMode() == PadWrenchData.OperationMode.ADD) {
            MutableComponent message = Component.translatable((String)"item.mobflowutilities.pad_wrench.error.no_controller");
            player.displayClientMessage((Component)message, true);
            return;
        }
        int minX = Math.min(pos1.getX(), pos2.getX());
        int maxX = Math.max(pos1.getX(), pos2.getX());
        int minY = Math.min(pos1.getY(), pos2.getY());
        int maxY = Math.max(pos1.getY(), pos2.getY());
        int minZ = Math.min(pos1.getZ(), pos2.getZ());
        int maxZ = Math.max(pos1.getZ(), pos2.getZ());
        ControllerBlockEntity controller = null;
        if (data.selectedController() != null && (be = level.getBlockEntity(data.selectedController())) instanceof ControllerBlockEntity) {
            ControllerBlockEntity controllerBE;
            controller = controllerBE = (ControllerBlockEntity)be;
        }
        int processedCount = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockEntity maybePadBE;
                    BlockPos currentPos = new BlockPos(x, y, z);
                    BlockState state = level.getBlockState(currentPos);
                    if (!(state.getBlock() instanceof DamagePadBlock) || !((maybePadBE = level.getBlockEntity(currentPos)) instanceof DamagePadBlockEntity)) continue;
                    DamagePadBlockEntity padEntity = (DamagePadBlockEntity)maybePadBE;
                    if (data.operationMode() == PadWrenchData.OperationMode.ADD) {
                        padEntity.setControllerPos(data.selectedController());
                        if (controller != null) {
                            controller.addPad(currentPos);
                        }
                    } else {
                        BlockEntity oldControllerBE;
                        BlockPos oldControllerPos = padEntity.getControllerPos();
                        padEntity.clearControllerPos();
                        if (oldControllerPos != null && (oldControllerBE = level.getBlockEntity(oldControllerPos)) instanceof ControllerBlockEntity) {
                            ControllerBlockEntity oldController = (ControllerBlockEntity)oldControllerBE;
                            oldController.removePad(currentPos);
                        }
                    }
                    ++processedCount;
                }
            }
        }
        MutableComponent message = data.operationMode() == PadWrenchData.OperationMode.ADD ? Component.translatable((String)"item.mobflowutilities.pad_wrench.multi.linked", (Object[])new Object[]{processedCount}) : Component.translatable((String)"item.mobflowutilities.pad_wrench.multi.unlinked", (Object[])new Object[]{processedCount});
        player.displayClientMessage((Component)message, true);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.mobflowutilities.pad_wrench.subtitle").withStyle(ChatFormatting.LIGHT_PURPLE));
        PadWrenchData data = (PadWrenchData)stack.getOrDefault((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)PadWrenchData.DEFAULT);
        MutableComponent operationText = data.operationMode() == PadWrenchData.OperationMode.ADD ? Component.translatable((String)"item.mobflowutilities.pad_wrench.tooltip.operation.add").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"item.mobflowutilities.pad_wrench.tooltip.operation.remove").withStyle(ChatFormatting.GOLD);
        tooltipComponents.add((Component)operationText);
        MutableComponent selectionText = data.selectionMode() == PadWrenchData.SelectionMode.SINGLE ? Component.translatable((String)"item.mobflowutilities.pad_wrench.tooltip.selection.single").withStyle(ChatFormatting.AQUA) : Component.translatable((String)"item.mobflowutilities.pad_wrench.tooltip.selection.multi").withStyle(ChatFormatting.RED);
        tooltipComponents.add((Component)selectionText);
        if (data.selectedController() != null) {
            MutableComponent controllerText = Component.translatable((String)"item.mobflowutilities.pad_wrench.tooltip.controller.selected", (Object[])new Object[]{data.selectedController().getX(), data.selectedController().getY(), data.selectedController().getZ()}).withStyle(ChatFormatting.YELLOW);
            tooltipComponents.add((Component)controllerText);
        } else {
            MutableComponent controllerText = Component.translatable((String)"item.mobflowutilities.pad_wrench.tooltip.controller.none").withStyle(ChatFormatting.GOLD);
            tooltipComponents.add((Component)controllerText);
        }
        if (data.firstMultiPos() != null) {
            MutableComponent multiText = Component.translatable((String)"item.mobflowutilities.pad_wrench.tooltip.multi.active", (Object[])new Object[]{data.firstMultiPos().getX(), data.firstMultiPos().getY(), data.firstMultiPos().getZ()}).withStyle(ChatFormatting.YELLOW);
            tooltipComponents.add((Component)multiText);
        }
        tooltipComponents.add((Component)Component.literal((String)""));
        tooltipComponents.add((Component)Component.translatable((String)"item.mobflowutilities.pad_wrench.tooltip.usage.selection").withStyle(ChatFormatting.DARK_GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"item.mobflowutilities.pad_wrench.tooltip.usage.operation").withStyle(ChatFormatting.DARK_GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"item.mobflowutilities.pad_wrench.tooltip.usage.controller").withStyle(ChatFormatting.DARK_GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"item.mobflowutilities.pad_wrench.tooltip.usage.pad").withStyle(ChatFormatting.DARK_GRAY));
    }
}

