/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.item.custom;

import com.misterd.mobflowutilities.component.MFUDataComponents;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class GeneSampleVialItem
extends Item {
    public GeneSampleVialItem(Item.Properties properties) {
        super(properties);
    }

    public boolean hasDNA(ItemStack stack) {
        return stack.has((DataComponentType)MFUDataComponents.ENTITY_DNA.get());
    }

    public Optional<EntityType<?>> getStoredEntityType(ItemStack stack) {
        ResourceLocation entityKey = (ResourceLocation)stack.get((DataComponentType)MFUDataComponents.ENTITY_DNA.get());
        return entityKey == null ? Optional.empty() : BuiltInRegistries.ENTITY_TYPE.getOptional(entityKey);
    }

    public String getStoredEntityName(ItemStack stack) {
        return this.getStoredEntityType(stack).map(entityType -> entityType.getDescription().getString()).orElse("Unknown");
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ResourceLocation entityKey = (ResourceLocation)stack.get((DataComponentType)MFUDataComponents.ENTITY_DNA.get());
        if (stack.has((DataComponentType)MFUDataComponents.ENTITY_DNA.get()) && entityKey != null) {
            String entityName = this.getStoredEntityName(stack);
            tooltipComponents.add((Component)Component.translatable((String)"item.mobflowutilities.gene_sample_vial.contains", (Object[])new Object[]{entityName}).withStyle(ChatFormatting.GREEN));
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.translatable((String)"item.mobflowutilities.gene_sample_vial.usage").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.mobflowutilities.gene_sample_vial.empty").withStyle(ChatFormatting.RED));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public boolean isFoil(ItemStack stack) {
        return this.hasDNA(stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.hasDNA(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return this.hasDNA(stack) ? 13 : 0;
    }
}

