/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.gui.custom;

import com.misterd.mobflowutilities.client.renderer.GenesisChamberWireframeRenderer;
import com.misterd.mobflowutilities.gui.custom.GenesisChamberMenu;
import com.misterd.mobflowutilities.network.ConfigPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.neoforged.neoforge.network.PacketDistributor;

public class GenesisChamberScreen
extends AbstractContainerScreen<GenesisChamberMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"textures/gui/genesis_chamber_gui.png");
    private static final WidgetSprites REDUCE_OFFSET_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"reduce_offset_btn"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"reduce_offset_btn"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"reduce_offset_btn_hover"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"reduce_offset_btn_hover"));
    private static final WidgetSprites INCREASE_OFFSET_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"increase_offset_btn"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"increase_offset_btn"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"increase_offset_btn_hover"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"increase_offset_btn_hover"));
    private static final WidgetSprites RESET_OFFSET_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"collection_zone_offset_reset_btn"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"collection_zone_offset_reset_btn"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"collection_zone_offset_reset_btn_hover"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"collection_zone_offset_reset_btn_hover"));
    private static final WidgetSprites TOGGLE_WIREFRAME_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"toggle_zone_wireframe_btn"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"toggle_zone_wireframe_btn"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"toggle_zone_wireframe_btn_hover"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"toggle_zone_wireframe_btn_hover"));
    private int downUpOffset = 0;
    private int northSouthOffset = 0;
    private int eastWestOffset = 0;
    private boolean showWireframe = false;
    private boolean requiresRedstone = false;

    public GenesisChamberScreen(GenesisChamberMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 189;
        this.inventoryLabelY = this.imageHeight - 96;
    }

    protected void init() {
        super.init();
        int leftPos = (this.width - this.imageWidth) / 2;
        int topPos = (this.height - this.imageHeight) / 2;
        this.clearWidgets();
        this.addOffsetButtons(leftPos, topPos);
        this.addWireframeButton(leftPos, topPos);
        this.syncFromBlockEntity();
    }

    private void addOffsetButtons(int leftPos, int topPos) {
        ImageButton duDecreaseButton = new ImageButton(leftPos + 121, topPos + 17, 10, 10, REDUCE_OFFSET_SPRITES, button -> this.adjustOffset("downUp", -1));
        duDecreaseButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.mobflowutilities.collector.offset.down_up.decrease")));
        this.addRenderableWidget((GuiEventListener)duDecreaseButton);
        ImageButton duIncreaseButton = new ImageButton(leftPos + 153, topPos + 17, 10, 10, INCREASE_OFFSET_SPRITES, button -> this.adjustOffset("downUp", 1));
        duIncreaseButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.mobflowutilities.collector.offset.down_up.increase")));
        this.addRenderableWidget((GuiEventListener)duIncreaseButton);
        ImageButton nsDecreaseButton = new ImageButton(leftPos + 121, topPos + 39, 10, 10, REDUCE_OFFSET_SPRITES, button -> this.adjustOffset("northSouth", -1));
        nsDecreaseButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.mobflowutilities.collector.offset.north_south.decrease")));
        this.addRenderableWidget((GuiEventListener)nsDecreaseButton);
        ImageButton nsIncreaseButton = new ImageButton(leftPos + 153, topPos + 39, 10, 10, INCREASE_OFFSET_SPRITES, button -> this.adjustOffset("northSouth", 1));
        nsIncreaseButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.mobflowutilities.collector.offset.north_south.increase")));
        this.addRenderableWidget((GuiEventListener)nsIncreaseButton);
        ImageButton ewDecreaseButton = new ImageButton(leftPos + 121, topPos + 61, 10, 10, REDUCE_OFFSET_SPRITES, button -> this.adjustOffset("eastWest", -1));
        ewDecreaseButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.mobflowutilities.collector.offset.east_west.decrease")));
        this.addRenderableWidget((GuiEventListener)ewDecreaseButton);
        ImageButton ewIncreaseButton = new ImageButton(leftPos + 153, topPos + 61, 10, 10, INCREASE_OFFSET_SPRITES, button -> this.adjustOffset("eastWest", 1));
        ewIncreaseButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.mobflowutilities.collector.offset.east_west.increase")));
        this.addRenderableWidget((GuiEventListener)ewIncreaseButton);
        ImageButton resetOffsetButton = new ImageButton(leftPos + 136, topPos + 76, 12, 12, RESET_OFFSET_SPRITES, button -> this.resetAllOffsets());
        resetOffsetButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.mobflowutilities.collector.offset.reset_all")));
        this.addRenderableWidget((GuiEventListener)resetOffsetButton);
    }

    private void addWireframeButton(int leftPos, int topPos) {
        ImageButton wireframeButton = new ImageButton(leftPos + 153, topPos + 77, 10, 10, this.createConditionalSprites(TOGGLE_WIREFRAME_SPRITES, () -> this.showWireframe), button -> this.toggleWireframe());
        wireframeButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.mobflowutilities.genesis_chamber.wireframe_toggle")));
        this.addRenderableWidget((GuiEventListener)wireframeButton);
    }

    private WidgetSprites createConditionalSprites(WidgetSprites baseSprites, Supplier<Boolean> condition) {
        return condition.get() != false ? new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)(baseSprites.enabled().getPath() + "_active")), baseSprites.disabled(), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)baseSprites.enabledFocused().getPath().replace("_hover", "_active")), baseSprites.disabledFocused()) : baseSprites;
    }

    private void adjustOffset(String axis, int delta) {
        int newValue;
        ConfigPacket.ConfigType configType;
        switch (axis) {
            case "downUp": {
                configType = ConfigPacket.ConfigType.GENESIS_CHAMBER_DOWN_UP_OFFSET;
                this.downUpOffset = newValue = Math.max(-10, Math.min(10, this.downUpOffset + delta));
                break;
            }
            case "northSouth": {
                configType = ConfigPacket.ConfigType.GENESIS_CHAMBER_NORTH_SOUTH_OFFSET;
                this.northSouthOffset = newValue = Math.max(-10, Math.min(10, this.northSouthOffset + delta));
                break;
            }
            case "eastWest": {
                configType = ConfigPacket.ConfigType.GENESIS_CHAMBER_EAST_WEST_OFFSET;
                this.eastWestOffset = newValue = Math.max(-10, Math.min(10, this.eastWestOffset + delta));
                break;
            }
            default: {
                return;
            }
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ConfigPacket(ConfigPacket.ConfigTarget.GENESIS_CHAMBER_BLOCK, ((GenesisChamberMenu)this.menu).blockEntity.getBlockPos(), configType, newValue, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void toggleWireframe() {
        this.showWireframe = !this.showWireframe;
        GenesisChamberWireframeRenderer.toggleWireframe(((GenesisChamberMenu)this.menu).blockEntity.getBlockPos());
        this.init();
    }

    private void resetAllOffsets() {
        this.downUpOffset = 0;
        this.northSouthOffset = 0;
        this.eastWestOffset = 0;
        PacketDistributor.sendToServer((CustomPacketPayload)new ConfigPacket(ConfigPacket.ConfigTarget.GENESIS_CHAMBER_BLOCK, ((GenesisChamberMenu)this.menu).blockEntity.getBlockPos(), ConfigPacket.ConfigType.GENESIS_CHAMBER_DOWN_UP_OFFSET, 0, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToServer((CustomPacketPayload)new ConfigPacket(ConfigPacket.ConfigTarget.GENESIS_CHAMBER_BLOCK, ((GenesisChamberMenu)this.menu).blockEntity.getBlockPos(), ConfigPacket.ConfigType.GENESIS_CHAMBER_NORTH_SOUTH_OFFSET, 0, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToServer((CustomPacketPayload)new ConfigPacket(ConfigPacket.ConfigTarget.GENESIS_CHAMBER_BLOCK, ((GenesisChamberMenu)this.menu).blockEntity.getBlockPos(), ConfigPacket.ConfigType.GENESIS_CHAMBER_EAST_WEST_OFFSET, 0, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void syncFromBlockEntity() {
        if (((GenesisChamberMenu)this.menu).blockEntity != null) {
            this.downUpOffset = ((GenesisChamberMenu)this.menu).blockEntity.getDownUpOffset();
            this.northSouthOffset = ((GenesisChamberMenu)this.menu).blockEntity.getNorthSouthOffset();
            this.eastWestOffset = ((GenesisChamberMenu)this.menu).blockEntity.getEastWestOffset();
            this.showWireframe = GenesisChamberWireframeRenderer.isWireframeActive(((GenesisChamberMenu)this.menu).blockEntity.getBlockPos());
            this.requiresRedstone = ((GenesisChamberMenu)this.menu).blockEntity.getRequiresRedstone();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (mouseX >= (double)(x + 55) && mouseX <= (double)(x + 67) && mouseY >= (double)(y + 73) && mouseY <= (double)(y + 85)) {
            this.requiresRedstone = !this.requiresRedstone;
            PacketDistributor.sendToServer((CustomPacketPayload)new ConfigPacket(ConfigPacket.ConfigTarget.GENESIS_CHAMBER_BLOCK, ((GenesisChamberMenu)this.menu).blockEntity.getBlockPos(), ConfigPacket.ConfigType.GENESIS_CHAMBER_REDSTONE_MODE, 0, this.requiresRedstone), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderBurnProgress(guiGraphics, x, y);
        this.renderMobPreview(guiGraphics, x, y, mouseX, mouseY);
        this.renderRedstoneToggle(guiGraphics, x, y);
    }

    private void renderBurnProgress(GuiGraphics guiGraphics, int x, int y) {
        if (((GenesisChamberMenu)this.menu).blockEntity != null) {
            int progress;
            int burnTime = ((GenesisChamberMenu)this.menu).blockEntity.getBurnTime();
            int maxBurnTime = ((GenesisChamberMenu)this.menu).blockEntity.getMaxBurnTime();
            if (maxBurnTime > 0 && (progress = (int)(13.0 * (double)burnTime / (double)maxBurnTime)) > 0) {
                guiGraphics.blit(GUI_TEXTURE, x + 81, y + 50 + (13 - progress), 176, 13 - progress, 14, progress);
            }
        }
    }

    private void renderMobPreview(GuiGraphics guiGraphics, int screenX, int screenY, int mouseX, int mouseY) {
        if (((GenesisChamberMenu)this.menu).blockEntity == null) {
            return;
        }
        ItemStack eggStack = ((GenesisChamberMenu)this.menu).blockEntity.inventory.getStackInSlot(0);
        Item item = eggStack.getItem();
        if (!(item instanceof SpawnEggItem)) {
            return;
        }
        SpawnEggItem spawnEgg = (SpawnEggItem)item;
        EntityType entityType = spawnEgg.getType(eggStack);
        if (entityType == null) {
            return;
        }
        Entity entity = ((GenesisChamberMenu)this.menu).blockEntity.getOrCreateRenderedEntity(entityType);
        if (entity == null) {
            return;
        }
        int centerX = screenX + 25;
        int centerY = screenY + 26;
        int scale = 17;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(centerX - 17), (int)(centerY - 8), (int)(centerX + 17), (int)(centerY + 38), (int)scale, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)livingEntity);
        }
    }

    private void renderRedstoneToggle(GuiGraphics guiGraphics, int x, int y) {
        ResourceLocation sprite = this.requiresRedstone ? ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"redstone_required_btn") : ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"no_redstone_required_btn");
        guiGraphics.blitSprite(sprite, x + 55, y + 73, 12, 12);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.syncFromBlockEntity();
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderCustomTooltips(guiGraphics, mouseX, mouseY);
    }

    private void renderCustomTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (mouseX >= x + 55 && mouseX <= x + 67 && mouseY >= y + 73 && mouseY <= y + 85) {
            MutableComponent tooltipText = this.requiresRedstone ? Component.translatable((String)"tooltip.mobflowutilities.genesis_chamber.redstone_required") : Component.translatable((String)"tooltip.mobflowutilities.genesis_chamber.no_redstone_required");
            guiGraphics.renderTooltip(this.font, (Component)tooltipText, mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderOffsetValues(guiGraphics, mouseX, mouseY);
    }

    private void renderOffsetValues(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        PoseStack poseStack = guiGraphics.pose();
        float scale = 0.7f;
        poseStack.pushPose();
        poseStack.scale(scale, scale, 1.0f);
        guiGraphics.drawString(this.font, (this.downUpOffset >= 0 ? "+" : "") + this.downUpOffset, (int)(137.0f / scale), (int)(20.0f / scale), 0, false);
        guiGraphics.drawString(this.font, (this.northSouthOffset >= 0 ? "+" : "") + this.northSouthOffset, (int)(137.0f / scale), (int)(42.0f / scale), 0, false);
        guiGraphics.drawString(this.font, (this.eastWestOffset >= 0 ? "+" : "") + this.eastWestOffset, (int)(137.0f / scale), (int)(64.0f / scale), 0, false);
        guiGraphics.drawString(this.font, Component.translatable((String)"gui.mobflowutilities.collector.offset.down_up").getString(), (int)(124.0f / scale), (int)(10.0f / scale), 0, false);
        guiGraphics.drawString(this.font, Component.translatable((String)"gui.mobflowutilities.collector.offset.north_south").getString(), (int)(124.0f / scale), (int)(32.0f / scale), 0, false);
        guiGraphics.drawString(this.font, Component.translatable((String)"gui.mobflowutilities.collector.offset.east_west").getString(), (int)(124.0f / scale), (int)(54.0f / scale), 0, false);
        poseStack.popPose();
    }
}

