/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.gui.custom;

import com.misterd.mobflowutilities.client.renderer.FanWireframeRenderer;
import com.misterd.mobflowutilities.gui.custom.FanMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class FanScreen
extends AbstractContainerScreen<FanMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"textures/gui/fan_gui.png");
    private static final WidgetSprites TOGGLE_WIREFRAME_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"toggle_zone_wireframe_btn"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"toggle_zone_wireframe_btn"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"toggle_zone_wireframe_btn_hover"), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)"toggle_zone_wireframe_btn_hover"));
    private boolean showWireframe = false;

    public FanScreen(FanMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 136;
        this.inventoryLabelY = this.imageHeight - 96;
    }

    protected void init() {
        super.init();
        int leftPos = (this.width - this.imageWidth) / 2;
        int topPos = (this.height - this.imageHeight) / 2;
        this.clearWidgets();
        this.addWireframeButton(leftPos, topPos);
        this.syncFromBlockEntity();
    }

    private void addWireframeButton(int leftPos, int topPos) {
        ImageButton wireframeButton = new ImageButton(leftPos + 155, topPos + 21, 12, 12, this.createConditionalSprites(TOGGLE_WIREFRAME_SPRITES, () -> this.showWireframe), button -> this.toggleWireframe());
        wireframeButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.mobflowutilities.fan.wireframe_toggle")));
        this.addRenderableWidget((GuiEventListener)wireframeButton);
    }

    private WidgetSprites createConditionalSprites(WidgetSprites baseSprites, Supplier<Boolean> isActive) {
        return isActive.get() != false ? new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)(baseSprites.enabled().getPath() + "_active")), baseSprites.disabled(), ResourceLocation.fromNamespaceAndPath((String)"mobflowutilities", (String)baseSprites.enabledFocused().getPath().replace("_hover", "_active")), baseSprites.disabledFocused()) : baseSprites;
    }

    private void toggleWireframe() {
        this.showWireframe = !this.showWireframe;
        FanWireframeRenderer.toggleWireframe(((FanMenu)this.menu).blockEntity.getBlockPos());
        this.init();
    }

    private void syncFromBlockEntity() {
        if (((FanMenu)this.menu).blockEntity != null) {
            this.showWireframe = FanWireframeRenderer.isWireframeActive(((FanMenu)this.menu).blockEntity.getBlockPos());
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.syncFromBlockEntity();
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

