/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.gui.custom;

import com.misterd.mobflowutilities.block.MFUBlocks;
import com.misterd.mobflowutilities.entity.custom.FanBlockEntity;
import com.misterd.mobflowutilities.gui.MFUMenuTypes;
import com.misterd.mobflowutilities.item.MFUItems;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class FanMenu
extends AbstractContainerMenu {
    public final FanBlockEntity blockEntity;
    private final Level level;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 3;

    public FanMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public FanMenu(int containerId, Inventory inv, BlockEntity blockEntity) {
        super((MenuType)MFUMenuTypes.FAN_MENU.get(), containerId);
        this.blockEntity = (FanBlockEntity)blockEntity;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.addSlot((Slot)new ModuleSlot((IItemHandler)this.blockEntity.inventory, 0, 44, 18, (Item)MFUItems.FAN_WIDTH_INCREASE_MODULE.get()));
        this.addSlot((Slot)new ModuleSlot((IItemHandler)this.blockEntity.inventory, 1, 80, 18, (Item)MFUItems.FAN_HEIGHT_INCREASE_MODULE.get()));
        this.addSlot((Slot)new ModuleSlot((IItemHandler)this.blockEntity.inventory, 2, 116, 18, (Item)MFUItems.FAN_DISTANCE_INCREASE_MODULE.get()));
    }

    public boolean stillValid(Player player) {
        return FanMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)MFUBlocks.FAN.get()));
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 39, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 39) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    private void addPlayerInventory(Inventory inv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 51 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory inv) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 8 + i * 18, 110));
        }
    }

    private static class ModuleSlot
    extends SlotItemHandler {
        private final Item allowedModule;

        public ModuleSlot(IItemHandler handler, int index, int x, int y, Item allowedModule) {
            super(handler, index, x, y);
            this.allowedModule = allowedModule;
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.getItem() == this.allowedModule;
        }

        public int getMaxStackSize(ItemStack stack) {
            return switch (this.getSlotIndex()) {
                case 0, 1 -> 4;
                case 2 -> 10;
                default -> 1;
            };
        }
    }
}

