/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.event;

import com.misterd.mobflowutilities.block.custom.DamagePadBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

@EventBusSubscriber
public class AttackPadTeleportInhibitor {
    private static final double INHIBIT_RANGE = 6.0;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityTeleport(EntityTeleportEvent event) {
        LivingEntity entity;
        if (!event.getEntity().level().isClientSide() && !(event instanceof EntityTeleportEvent.TeleportCommand) && !(event instanceof EntityTeleportEvent.SpreadPlayersCommand) && event.getEntity() instanceof LivingEntity && AttackPadTeleportInhibitor.shouldBlockTeleportation(entity = (LivingEntity)event.getEntity()) && AttackPadTeleportInhibitor.isNearAttackPad(entity)) {
            event.setCanceled(true);
        }
    }

    private static boolean shouldBlockTeleportation(LivingEntity entity) {
        if (entity instanceof EnderMan) {
            return true;
        }
        return entity instanceof Player ? false : false;
    }

    private static boolean isNearAttackPad(LivingEntity entity) {
        AABB searchArea = entity.getBoundingBox().inflate(6.0, 6.0, 6.0);
        int minX = Mth.floor((double)searchArea.minX);
        int maxX = Mth.floor((double)searchArea.maxX);
        int minY = Mth.floor((double)searchArea.minY);
        int maxY = Mth.floor((double)searchArea.maxY);
        int minZ = Mth.floor((double)searchArea.minZ);
        int maxZ = Mth.floor((double)searchArea.maxZ);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    mutablePos.set(x, y, z);
                    BlockState state = entity.level().getBlockState((BlockPos)mutablePos);
                    if (!(state.getBlock() instanceof DamagePadBlock)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

