/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.entity.custom;

import com.misterd.mobflowutilities.block.MFUBlocks;
import com.misterd.mobflowutilities.config.Config;
import com.misterd.mobflowutilities.entity.MFUBlockEntities;
import com.misterd.mobflowutilities.gui.custom.GenesisChamberMenu;
import com.misterd.mobflowutilities.util.MFUTags;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class GenesisChamberBlockEntity
extends BlockEntity
implements MenuProvider {
    public Entity cachedEntity = null;
    private int downUpOffset = 0;
    private int northSouthOffset = 0;
    private int eastWestOffset = 0;
    private int burnTime = 0;
    private int maxBurnTime = 0;
    private int spawnTimer = 0;
    private boolean requiresRedstone = false;
    public final ItemStackHandler inventory = new ItemStackHandler(4){

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }

        protected void onContentsChanged(int slot) {
            GenesisChamberBlockEntity.this.setChanged();
            if (!GenesisChamberBlockEntity.this.level.isClientSide()) {
                GenesisChamberBlockEntity.this.level.sendBlockUpdated(GenesisChamberBlockEntity.this.getBlockPos(), GenesisChamberBlockEntity.this.getBlockState(), GenesisChamberBlockEntity.this.getBlockState(), 3);
            }
        }
    };

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return new IItemHandler(){

            public int getSlots() {
                return 1;
            }

            public ItemStack getStackInSlot(int slot) {
                return GenesisChamberBlockEntity.this.inventory.getStackInSlot(1);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (!stack.is(MFUTags.Items.GENESIS_CHAMBER_FUELS)) {
                    return stack;
                }
                return GenesisChamberBlockEntity.this.inventory.insertItem(1, stack, simulate);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.EMPTY;
            }

            public int getSlotLimit(int slot) {
                return GenesisChamberBlockEntity.this.inventory.getSlotLimit(1);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.is(MFUTags.Items.GENESIS_CHAMBER_FUELS);
            }
        };
    }

    public GenesisChamberBlockEntity(BlockPos pos, BlockState blockState) {
        super(MFUBlockEntities.GENESIS_CHAMBER_BE.get(), pos, blockState);
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("downUpOffset", this.downUpOffset);
        tag.putInt("northSouthOffset", this.northSouthOffset);
        tag.putInt("eastWestOffset", this.eastWestOffset);
        tag.putInt("burnTime", this.burnTime);
        tag.putInt("maxBurnTime", this.maxBurnTime);
        tag.putInt("spawnTimer", this.spawnTimer);
        tag.putBoolean("requiresRedstone", this.requiresRedstone);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        this.downUpOffset = tag.getInt("downUpOffset");
        this.northSouthOffset = tag.getInt("northSouthOffset");
        this.eastWestOffset = tag.getInt("eastWestOffset");
        this.burnTime = tag.getInt("burnTime");
        this.maxBurnTime = tag.getInt("maxBurnTime");
        this.spawnTimer = tag.getInt("spawnTimer");
        this.requiresRedstone = tag.getBoolean("requiresRedstone");
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.mobflowutilities.genesis_chamber");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new GenesisChamberMenu(i, inventory, this);
    }

    public Entity getOrCreateRenderedEntity(EntityType<?> type) {
        if (this.cachedEntity != null && this.cachedEntity.getType() == type) {
            return this.cachedEntity;
        }
        Level level = this.getLevel();
        if (level == null) {
            return null;
        }
        Entity entity = type.create(level);
        if (entity == null) {
            return null;
        }
        entity.noPhysics = true;
        if (entity instanceof Mob) {
            Mob mobEntity = (Mob)entity;
            mobEntity.setNoAi(true);
        }
        entity.invulnerableTime = Integer.MAX_VALUE;
        this.cachedEntity = entity;
        return entity;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public int getDownUpOffset() {
        return this.downUpOffset;
    }

    public void setDownUpOffset(int offset) {
        this.downUpOffset = Math.max(-10, Math.min(10, offset));
        this.setChanged();
    }

    public int getNorthSouthOffset() {
        return this.northSouthOffset;
    }

    public void setNorthSouthOffset(int offset) {
        this.northSouthOffset = Math.max(-10, Math.min(10, offset));
        this.setChanged();
    }

    public int getEastWestOffset() {
        return this.eastWestOffset;
    }

    public void setEastWestOffset(int offset) {
        this.eastWestOffset = Math.max(-10, Math.min(10, offset));
        this.setChanged();
    }

    public boolean getRequiresRedstone() {
        return this.requiresRedstone;
    }

    public void setRequiresRedstone(boolean requiresRedstone) {
        this.requiresRedstone = requiresRedstone;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getMaxBurnTime() {
        return this.maxBurnTime;
    }

    public void tick() {
        int fuelValue;
        ItemStack fuelStack;
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        boolean wasLit = this.burnTime > 0;
        boolean changed = false;
        boolean zoneIsFull = this.isSpawnZoneFull();
        if (this.requiresRedstone && !this.level.hasNeighborSignal(this.worldPosition)) {
            if (changed) {
                this.setChanged();
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
            return;
        }
        if (this.burnTime > 0 && !zoneIsFull) {
            --this.burnTime;
            changed = true;
        }
        if (this.burnTime <= 0 && this.canOperate() && !zoneIsFull && !(fuelStack = this.inventory.getStackInSlot(1)).isEmpty() && (fuelValue = this.getBurnDuration(fuelStack)) > 0) {
            this.burnTime = fuelValue;
            this.maxBurnTime = fuelValue;
            fuelStack.shrink(1);
            changed = true;
        }
        if (this.burnTime > 0 && this.canOperate() && !zoneIsFull) {
            ++this.spawnTimer;
            int spawnInterval = this.getSpawnInterval();
            if (this.spawnTimer >= spawnInterval && this.attemptSpawn()) {
                this.spawnTimer = 0;
                changed = true;
            }
        } else {
            this.spawnTimer = 0;
        }
        if (changed) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private boolean canOperate() {
        ItemStack eggStack = this.inventory.getStackInSlot(0);
        return eggStack.getItem() instanceof SpawnEggItem;
    }

    private int getSpawnInterval() {
        ItemStack speedModules = this.inventory.getStackInSlot(2);
        int moduleCount = Math.min(5, speedModules.getCount());
        return Math.max(50, 200 - moduleCount * 30);
    }

    private int getSpawnRadius() {
        ItemStack radiusModules = this.inventory.getStackInSlot(3);
        int moduleCount = Math.min(5, radiusModules.getCount());
        return 2 + moduleCount;
    }

    private boolean attemptSpawn() {
        ItemStack eggStack = this.inventory.getStackInSlot(0);
        Item item = eggStack.getItem();
        if (!(item instanceof SpawnEggItem)) {
            return false;
        }
        SpawnEggItem spawnEgg = (SpawnEggItem)item;
        EntityType entityType = spawnEgg.getType(eggStack);
        if (entityType == null) {
            return false;
        }
        List<BlockPos> validPositions = this.getValidSpawnPositions();
        if (validPositions.isEmpty()) {
            return false;
        }
        BlockPos spawnPos = validPositions.get(this.level.random.nextInt(validPositions.size()));
        if (!this.isValidLightLevel(spawnPos, entityType)) {
            return false;
        }
        Entity entity = entityType.create(this.level);
        if (entity == null) {
            return false;
        }
        entity.moveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, this.level.random.nextFloat() * 360.0f, 0.0f);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.finalizeSpawn((ServerLevelAccessor)this.level, this.level.getCurrentDifficultyAt(spawnPos), MobSpawnType.SPAWNER, null);
        }
        return this.level.addFreshEntity(entity);
    }

    private List<BlockPos> getValidSpawnPositions() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int radius = this.getSpawnRadius();
        BlockPos chamberPos = this.getBlockPos();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos checkPos;
                if (x == 0 && z == 0 || !this.isValidSpawnPosition(checkPos = chamberPos.offset(x + this.eastWestOffset, this.downUpOffset, z + this.northSouthOffset))) continue;
                positions.add(checkPos);
            }
        }
        return positions;
    }

    private boolean isValidSpawnPosition(BlockPos pos) {
        BlockState spawnState = this.level.getBlockState(pos);
        BlockState aboveState = this.level.getBlockState(pos.above());
        boolean hasSpace = !(!spawnState.isAir() && !spawnState.canBeReplaced() || !aboveState.isAir() && !aboveState.canBeReplaced());
        return hasSpace;
    }

    private boolean isFlowPad(BlockState state) {
        return state.is((Block)MFUBlocks.FAST_FLOW_PAD.get()) || state.is((Block)MFUBlocks.FASTER_FLOW_PAD.get()) || state.is((Block)MFUBlocks.FASTEST_FLOW_PAD.get());
    }

    private boolean isValidLightLevel(BlockPos pos, EntityType<?> entityType) {
        int lightLevel = this.level.getMaxLocalRawBrightness(pos);
        Entity testEntity = entityType.create(this.level);
        if (testEntity instanceof Mob) {
            Mob mob = (Mob)testEntity;
            boolean isFriendly = mob.getType().getCategory().isFriendly();
            testEntity.discard();
            if (isFriendly) {
                return lightLevel >= 9;
            }
            return lightLevel <= 7;
        }
        if (testEntity != null) {
            testEntity.discard();
        }
        return true;
    }

    private int getBurnDuration(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        if (!stack.is(MFUTags.Items.GENESIS_CHAMBER_FUELS)) {
            return 0;
        }
        return stack.getBurnTime(RecipeType.SMELTING);
    }

    private boolean isSpawnZoneFull() {
        AABB spawnZone = this.getSpawnZoneAABB();
        List mobsInZone = this.level.getEntitiesOfClass(Mob.class, spawnZone);
        return mobsInZone.size() >= Config.getGenesisChamberSpawnCap();
    }

    private AABB getSpawnZoneAABB() {
        BlockPos pos = this.getBlockPos();
        int radius = this.getSpawnRadius();
        return new AABB((double)(pos.getX() - radius + this.eastWestOffset), (double)(pos.getY() + this.downUpOffset), (double)(pos.getZ() - radius + this.northSouthOffset), (double)(pos.getX() + radius + 1 + this.eastWestOffset), (double)(pos.getY() + 2 + this.downUpOffset), (double)(pos.getZ() + radius + 1 + this.northSouthOffset));
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, MFUBlockEntities.GENESIS_CHAMBER_BE.get(), (blockEntity, direction) -> {
            IItemHandler iItemHandler;
            if (blockEntity instanceof GenesisChamberBlockEntity) {
                GenesisChamberBlockEntity genesisChamberBlockEntity = blockEntity;
                iItemHandler = genesisChamberBlockEntity.getItemHandler((Direction)direction);
            } else {
                iItemHandler = null;
            }
            return iItemHandler;
        });
    }
}

