/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.entity.custom;

import com.misterd.mobflowutilities.block.MFUBlocks;
import com.misterd.mobflowutilities.entity.MFUBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FlowPadBlockEntity
extends BlockEntity {
    private static final int MOVEMENT_INTERVAL = 2;
    private int tickCounter = 0;
    private static final double FAST_SPEED = 0.15;
    private static final double FASTER_SPEED = 0.3;
    private static final double FASTEST_SPEED = 0.6;

    public FlowPadBlockEntity(BlockPos pos, BlockState blockState) {
        super(MFUBlockEntities.FLOW_PAD_BE.get(), pos, blockState);
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> createTicker() {
        return (level, pos, state, blockEntity) -> {
            if (blockEntity instanceof FlowPadBlockEntity) {
                FlowPadBlockEntity flowPad = (FlowPadBlockEntity)blockEntity;
                flowPad.tick();
            }
        };
    }

    public void tick() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= 2) {
            this.tickCounter = 0;
            this.applyMovement();
        }
    }

    private void applyMovement() {
        if (this.level == null) {
            return;
        }
        AABB movementArea = new AABB((double)this.worldPosition.getX() - 0.1, (double)this.worldPosition.getY() + 0.0625, (double)this.worldPosition.getZ() - 0.1, (double)this.worldPosition.getX() + 1.1, (double)this.worldPosition.getY() + 1.5, (double)this.worldPosition.getZ() + 1.1);
        List entities = this.level.getEntitiesOfClass(Entity.class, movementArea, this::shouldMoveEntity);
        if (entities.isEmpty()) {
            return;
        }
        Direction facing = this.getFacing();
        double speed = this.getSpeedMultiplier();
        Vec3 movement = this.getMovementVector(facing, speed);
        for (Entity entity : entities) {
            this.applyMovementToEntity(entity, movement);
        }
    }

    private boolean shouldMoveEntity(Entity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isShiftKeyDown()) {
            return false;
        }
        if (entity instanceof LivingEntity || entity instanceof ItemEntity) {
            double entityBottom = entity.getBoundingBox().minY;
            double padTop = (double)this.worldPosition.getY() + 0.0625;
            return Math.abs(entityBottom - padTop) < 0.1;
        }
        return false;
    }

    private Direction getFacing() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
            return (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        }
        return Direction.NORTH;
    }

    private double getSpeedMultiplier() {
        Block block = this.getBlockState().getBlock();
        if (block == MFUBlocks.FAST_FLOW_PAD.get()) {
            return 0.15;
        }
        if (block == MFUBlocks.FASTER_FLOW_PAD.get()) {
            return 0.3;
        }
        if (block == MFUBlocks.FASTEST_FLOW_PAD.get()) {
            return 0.6;
        }
        return 0.15;
    }

    private Vec3 getMovementVector(Direction facing, double speed) {
        return switch (facing) {
            case Direction.NORTH -> new Vec3(0.0, 0.0, speed);
            case Direction.SOUTH -> new Vec3(0.0, 0.0, -speed);
            case Direction.EAST -> new Vec3(-speed, 0.0, 0.0);
            case Direction.WEST -> new Vec3(speed, 0.0, 0.0);
            default -> Vec3.ZERO;
        };
    }

    private void applyMovementToEntity(Entity entity, Vec3 movement) {
        Vec3 currentVelocity = entity.getDeltaMovement();
        Vec3 newVelocity = currentVelocity.add(movement);
        double maxVelocity = 2.0;
        newVelocity = new Vec3(Math.max(-maxVelocity, Math.min(maxVelocity, newVelocity.x)), newVelocity.y, Math.max(-maxVelocity, Math.min(maxVelocity, newVelocity.z)));
        entity.setDeltaMovement(newVelocity);
        entity.hurtMarked = true;
    }
}

