/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.entity.custom;

import com.misterd.mobflowutilities.block.custom.FanBlock;
import com.misterd.mobflowutilities.entity.MFUBlockEntities;
import com.misterd.mobflowutilities.gui.custom.FanMenu;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class FanBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler inventory = new ItemStackHandler(3){

        public int getSlotLimit(int slot) {
            return switch (slot) {
                case 0, 1 -> 4;
                case 2 -> 10;
                default -> 1;
            };
        }

        protected void onContentsChanged(int slot) {
            FanBlockEntity.this.setChanged();
            if (FanBlockEntity.this.level != null && !FanBlockEntity.this.level.isClientSide()) {
                FanBlockEntity.this.level.sendBlockUpdated(FanBlockEntity.this.worldPosition, FanBlockEntity.this.getBlockState(), FanBlockEntity.this.getBlockState(), 3);
            }
            FanBlockEntity.this.invalidateCaches();
        }
    };
    private AABB cachedPushZone;
    private Integer cachedDistance;
    private Integer cachedWidth;
    private Integer cachedHeight;

    public FanBlockEntity(BlockPos pos, BlockState state) {
        super(MFUBlockEntities.FAN_BE.get(), pos, state);
    }

    public void tick() {
        if (this.level == null) {
            return;
        }
        if (!this.level.isClientSide && ((Boolean)this.getBlockState().getValue((Property)FanBlock.POWERED)).booleanValue()) {
            this.pushEntities(this.level);
        }
    }

    public int getDistance() {
        if (this.cachedDistance != null) {
            return this.cachedDistance;
        }
        int modules = this.inventory.getStackInSlot(2).getCount();
        this.cachedDistance = Math.min(4 + modules, 15);
        return this.cachedDistance;
    }

    public int getWidth() {
        if (this.cachedWidth != null) {
            return this.cachedWidth;
        }
        this.cachedWidth = this.inventory.getStackInSlot(0).getCount();
        return this.cachedWidth;
    }

    public int getHeight() {
        if (this.cachedHeight != null) {
            return this.cachedHeight;
        }
        this.cachedHeight = this.inventory.getStackInSlot(1).getCount();
        return this.cachedHeight;
    }

    public AABB getPushZone() {
        if (this.cachedPushZone != null) {
            return this.cachedPushZone;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)FanBlock.FACING);
        int d = this.getDistance();
        int w = this.getWidth();
        int h = this.getHeight();
        BlockPos o = this.worldPosition.relative(facing);
        this.cachedPushZone = switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> new AABB((double)(o.getX() - w), (double)(o.getY() - h), (double)(o.getZ() - d), (double)(o.getX() + w + 1), (double)(o.getY() + h + 1), (double)(o.getZ() + 1));
            case Direction.SOUTH -> new AABB((double)(o.getX() - w), (double)(o.getY() - h), (double)o.getZ(), (double)(o.getX() + w + 1), (double)(o.getY() + h + 1), (double)(o.getZ() + d + 1));
            case Direction.WEST -> new AABB((double)(o.getX() - d), (double)(o.getY() - h), (double)(o.getZ() - w), (double)(o.getX() + 1), (double)(o.getY() + h + 1), (double)(o.getZ() + w + 1));
            case Direction.EAST -> new AABB((double)o.getX(), (double)(o.getY() - h), (double)(o.getZ() - w), (double)(o.getX() + d + 1), (double)(o.getY() + h + 1), (double)(o.getZ() + w + 1));
            case Direction.DOWN -> new AABB((double)(o.getX() - w), (double)(o.getY() - d), (double)(o.getZ() - h), (double)(o.getX() + w + 1), (double)(o.getY() + 1), (double)(o.getZ() + h + 1));
            case Direction.UP -> new AABB((double)(o.getX() - w), (double)o.getY(), (double)(o.getZ() - h), (double)(o.getX() + w + 1), (double)(o.getY() + d + 1), (double)(o.getZ() + h + 1));
        };
        return this.cachedPushZone;
    }

    private void pushEntities(Level level) {
        AABB zone = this.getPushZone();
        Direction facing = (Direction)this.getBlockState().getValue((Property)FanBlock.FACING);
        Vec3 push = Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale(0.3);
        List entities = level.getEntitiesOfClass(LivingEntity.class, zone);
        for (LivingEntity entity : entities) {
            if (!this.hasClearLane(level, entity)) continue;
            entity.push(push.x, push.y, push.z);
            entity.hurtMarked = true;
        }
    }

    private boolean hasClearLane(Level level, LivingEntity entity) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)FanBlock.FACING);
        BlockPos start = this.worldPosition.relative(facing);
        BlockPos end = entity.blockPosition();
        int steps = switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.SOUTH -> Math.abs(end.getZ() - start.getZ());
            case Direction.WEST, Direction.EAST -> Math.abs(end.getX() - start.getX());
            case Direction.DOWN, Direction.UP -> Math.abs(end.getY() - start.getY());
        };
        int dx = Integer.signum(end.getX() - start.getX());
        int dy = Integer.signum(end.getY() - start.getY());
        int dz = Integer.signum(end.getZ() - start.getZ());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(start.getX(), start.getY(), start.getZ());
        for (int i = 0; i < steps; ++i) {
            pos.move(dx, dy, dz);
            BlockState state = level.getBlockState((BlockPos)pos);
            if (state.isAir() || !state.isSolidRender((BlockGetter)level, (BlockPos)pos)) continue;
            return false;
        }
        return true;
    }

    private void invalidateCaches() {
        this.cachedPushZone = null;
        this.cachedDistance = null;
        this.cachedWidth = null;
        this.cachedHeight = null;
    }

    public void dropContents() {
        if (this.level != null) {
            SimpleContainer container = new SimpleContainer(this.inventory.getSlots());
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                container.setItem(i, this.inventory.getStackInSlot(i));
            }
            Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)container);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        this.invalidateCaches();
    }

    public Component getDisplayName() {
        return Component.translatable((String)"menu.mobflowutilities.fan");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new FanMenu(id, inv, this);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

