/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.entity.custom;

import com.misterd.mobflowutilities.entity.MFUBlockEntities;
import com.misterd.mobflowutilities.entity.custom.DamagePadBlockEntity;
import com.misterd.mobflowutilities.gui.custom.ControllerMenu;
import com.misterd.mobflowutilities.item.MFUItems;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ControllerBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler inventory = new ItemStackHandler(5){

        public int getSlotLimit(int slot) {
            return 10;
        }

        protected void onContentsChanged(int slot) {
            ControllerBlockEntity.this.setChanged();
            if (!ControllerBlockEntity.this.level.isClientSide()) {
                ControllerBlockEntity.this.level.sendBlockUpdated(ControllerBlockEntity.this.getBlockPos(), ControllerBlockEntity.this.getBlockState(), ControllerBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.getItem() == MFUItems.SHARPNESS_MODULE.get();
                case 1 -> stack.getItem() == MFUItems.FIRE_ASPECT_MODULE.get();
                case 2 -> stack.getItem() == MFUItems.SMITE_MODULE.get();
                case 3 -> stack.getItem() == MFUItems.BOA_MODULE.get();
                case 4 -> stack.getItem() == MFUItems.LOOTING_MODULE.get();
                default -> false;
            };
        }
    };
    private final Set<BlockPos> linkedPads = new HashSet<BlockPos>();
    private boolean playerKillMode = false;

    public ControllerBlockEntity(BlockPos pos, BlockState blockState) {
        super(MFUBlockEntities.CONTROLLER_BE.get(), pos, blockState);
    }

    public void addPad(BlockPos padPos) {
        this.linkedPads.add(padPos);
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void removePad(BlockPos padPos) {
        this.linkedPads.remove(padPos);
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public Set<BlockPos> getLinkedPads() {
        return new HashSet<BlockPos>(this.linkedPads);
    }

    public List<BlockPos> getLinkedPadsList() {
        return new ArrayList<BlockPos>(this.linkedPads);
    }

    public int getLinkedPadCount() {
        return this.linkedPads.size();
    }

    public void clearAllLinkedPads() {
        if (this.level != null && !this.level.isClientSide()) {
            for (BlockPos padPos : this.linkedPads) {
                BlockEntity var4 = this.level.getBlockEntity(padPos);
                if (!(var4 instanceof DamagePadBlockEntity)) continue;
                DamagePadBlockEntity attackPad = (DamagePadBlockEntity)var4;
                attackPad.clearControllerPos();
            }
        }
        this.linkedPads.clear();
        this.setChanged();
    }

    public boolean isPlayerKillMode() {
        return this.playerKillMode;
    }

    public void setPlayerKillMode(boolean playerKillMode) {
        this.playerKillMode = playerKillMode;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getModuleCount(int slot) {
        if (slot >= 0 && slot < this.inventory.getSlots()) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            return stack.isEmpty() ? 0 : Math.min(stack.getCount(), 10);
        }
        return 0;
    }

    public boolean hasSharpnessModule() {
        return this.getModuleCount(0) > 0;
    }

    public boolean hasFireAspectModule() {
        return this.getModuleCount(1) > 0;
    }

    public boolean hasSmiteModule() {
        return this.getModuleCount(2) > 0;
    }

    public boolean hasBaneOfArthropodsModule() {
        return this.getModuleCount(3) > 0;
    }

    public boolean hasLootingModule() {
        return this.getModuleCount(4) > 0;
    }

    public int getSharpnessLevel() {
        return this.getModuleCount(0);
    }

    public int getFireAspectLevel() {
        return this.getModuleCount(1);
    }

    public int getSmiteLevel() {
        return this.getModuleCount(2);
    }

    public int getBaneOfArthropodsLevel() {
        return this.getModuleCount(3);
    }

    public int getLootingLevel() {
        return this.getModuleCount(4);
    }

    public void clearContents() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
        this.setChanged();
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    public boolean removePadAt(BlockPos padPos) {
        if (this.linkedPads.remove(padPos)) {
            if (this.level != null && !this.level.isClientSide()) {
                BlockEntity var3 = this.level.getBlockEntity(padPos);
                if (var3 instanceof DamagePadBlockEntity) {
                    DamagePadBlockEntity attackPad = (DamagePadBlockEntity)var3;
                    attackPad.clearControllerPos();
                }
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
            this.setChanged();
            return true;
        }
        return false;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putBoolean("playerKillMode", this.playerKillMode);
        ListTag padList = new ListTag();
        for (BlockPos padPos : this.linkedPads) {
            padList.add((Object)LongTag.valueOf((long)padPos.asLong()));
        }
        tag.put("linkedPads", (Tag)padList);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        this.playerKillMode = tag.getBoolean("playerKillMode");
        this.linkedPads.clear();
        if (tag.contains("linkedPads")) {
            ListTag padList = tag.getList("linkedPads", 4);
            for (int i = 0; i < padList.size(); ++i) {
                long posLong = ((LongTag)padList.get(i)).getAsLong();
                BlockPos padPos = BlockPos.of((long)posLong);
                this.linkedPads.add(padPos);
            }
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"menu.mobflowutilities.controller");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new ControllerMenu(i, inventory, this);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }
}

