/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.entity.custom;

import com.misterd.mobflowutilities.block.custom.CollectorBlock;
import com.misterd.mobflowutilities.component.MFUDataComponents;
import com.misterd.mobflowutilities.component.custom.VoidFilterData;
import com.misterd.mobflowutilities.entity.MFUBlockEntities;
import com.misterd.mobflowutilities.gui.custom.CollectorMenu;
import com.misterd.mobflowutilities.item.custom.VoidFilterItem;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.slf4j.Logger;

public class CollectorBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int COLLECTION_INTERVAL = 5;
    private AABB cachedCollectionArea;
    private boolean collectionAreaDirty = true;
    private int cachedPickupRange = -1;
    private boolean pickupRangeDirty = true;
    private int tickCounter = 0;
    public final ItemStackHandler moduleSlots = new ItemStackHandler(4){

        public int getSlotLimit(int slot) {
            return switch (slot) {
                case 0 -> 8;
                case 1, 2, 3 -> 1;
                default -> 1;
            };
        }

        protected void onContentsChanged(int slot) {
            if (slot == 0) {
                CollectorBlockEntity.this.invalidatePickupRangeCache();
            }
            CollectorBlockEntity.this.setChanged();
            if (!CollectorBlockEntity.this.level.isClientSide()) {
                try {
                    CollectorBlockEntity.this.level.sendBlockUpdated(CollectorBlockEntity.this.getBlockPos(), CollectorBlockEntity.this.getBlockState(), CollectorBlockEntity.this.getBlockState(), 3);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to send block update for collector at {}", (Object)CollectorBlockEntity.this.getBlockPos(), (Object)e);
                }
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (stack.isEmpty()) {
                return true;
            }
            try {
                stack.save((HolderLookup.Provider)CollectorBlockEntity.this.level.registryAccess());
                return super.isItemValid(slot, stack);
            }
            catch (Exception e) {
                LOGGER.warn("Rejected invalid item {} for collector slot {}", new Object[]{stack, slot, e});
                return false;
            }
        }
    };
    public final ItemStackHandler outputInventory = new ItemStackHandler(45){

        protected int getStackLimit(int slot, ItemStack stack) {
            return stack.getMaxStackSize();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            int limit = this.getStackLimit(slot, stack);
            ItemStack existing = this.getStackInSlot(slot);
            if (!existing.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            int canInsert = limit - existing.getCount();
            if (canInsert <= 0) {
                return stack;
            }
            int toInsert = Math.min(stack.getCount(), canInsert);
            if (!simulate) {
                if (existing.isEmpty()) {
                    this.setStackInSlot(slot, stack.copyWithCount(toInsert));
                } else {
                    existing.grow(toInsert);
                }
            }
            return toInsert == stack.getCount() ? ItemStack.EMPTY : stack.copyWithCount(stack.getCount() - toInsert);
        }

        protected void onContentsChanged(int slot) {
            CollectorBlockEntity.this.setChanged();
            if (!CollectorBlockEntity.this.level.isClientSide()) {
                CollectorBlockEntity.this.level.sendBlockUpdated(CollectorBlockEntity.this.getBlockPos(), CollectorBlockEntity.this.getBlockState(), CollectorBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (stack.isEmpty()) {
                return false;
            }
            try {
                stack.save((HolderLookup.Provider)CollectorBlockEntity.this.level.registryAccess());
                return true;
            }
            catch (Exception e) {
                LOGGER.warn("Rejected invalid item {} for collector output slot {}", new Object[]{stack, slot, e});
                return false;
            }
        }
    };
    private int storedXP = 0;
    private boolean xpCollectionEnabled = false;
    private int downUpOffset = 0;
    private int northSouthOffset = 0;
    private int eastWestOffset = 0;

    public CollectorBlockEntity(BlockPos pos, BlockState blockState) {
        super(MFUBlockEntities.COLLECTOR_BE.get(), pos, blockState);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, MFUBlockEntities.COLLECTOR_BE.get(), (blockEntity, direction) -> {
            IItemHandler iItemHandler;
            if (blockEntity instanceof CollectorBlockEntity) {
                CollectorBlockEntity collector = blockEntity;
                iItemHandler = collector.getItemHandler((Direction)direction);
            } else {
                iItemHandler = null;
            }
            return iItemHandler;
        });
    }

    @Nullable
    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return this.outputInventory;
    }

    public void loadFromBlockItem(ItemStack stack) {
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return;
        }
        CompoundTag tag = customData.copyTag();
        if (this.level != null) {
            RegistryAccess registries = this.level.registryAccess();
            this.storedXP = tag.getInt("storedXP");
            this.xpCollectionEnabled = tag.getBoolean("xpCollectionEnabled");
            this.downUpOffset = tag.getInt("downUpOffset");
            this.northSouthOffset = tag.getInt("northSouthOffset");
            this.eastWestOffset = tag.getInt("eastWestOffset");
            if (!this.level.isClientSide()) {
                CollectorBlock.updateXpCollectionState(this.level, this.worldPosition, this.xpCollectionEnabled);
            }
            this.setChanged();
            if (!this.level.isClientSide()) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public int getStoredXP() {
        return this.storedXP;
    }

    public void setStoredXP(int xp) {
        int oldXP = this.storedXP;
        this.storedXP = Math.max(0, xp);
        if (oldXP != this.storedXP) {
            this.setChangedAndUpdate();
        }
    }

    public boolean isXpCollectionEnabled() {
        return this.xpCollectionEnabled;
    }

    public void setXpCollectionEnabled(boolean enabled) {
        if (this.xpCollectionEnabled == enabled) {
            return;
        }
        this.xpCollectionEnabled = enabled;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            CollectorBlock.updateXpCollectionState(this.level, this.worldPosition, enabled);
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getDownUpOffset() {
        return this.downUpOffset;
    }

    public void setDownUpOffset(int offset) {
        this.setOffset(() -> this.downUpOffset, offset, val -> {
            this.downUpOffset = val;
        });
    }

    public int getNorthSouthOffset() {
        return this.northSouthOffset;
    }

    public void setNorthSouthOffset(int offset) {
        this.setOffset(() -> this.northSouthOffset, offset, val -> {
            this.northSouthOffset = val;
        });
    }

    public int getEastWestOffset() {
        return this.eastWestOffset;
    }

    public void setEastWestOffset(int offset) {
        this.setOffset(() -> this.eastWestOffset, offset, val -> {
            this.eastWestOffset = val;
        });
    }

    private void setOffset(Callable<Integer> getter, int offset, IntConsumer setter) {
        int newOffset = Math.max(-10, Math.min(10, offset));
        try {
            if (getter.call() != newOffset) {
                setter.accept(newOffset);
                this.invalidateCollectionAreaCache();
                this.setChanged();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPickupRange() {
        if (this.pickupRangeDirty || this.cachedPickupRange == -1) {
            this.cachedPickupRange = 3 + this.moduleSlots.getStackInSlot(0).getCount();
            this.pickupRangeDirty = false;
        }
        return this.cachedPickupRange;
    }

    private void invalidateCollectionAreaCache() {
        this.collectionAreaDirty = true;
    }

    private void invalidatePickupRangeCache() {
        this.pickupRangeDirty = true;
        this.invalidateCollectionAreaCache();
    }

    public void invalidateAllCaches() {
        this.invalidatePickupRangeCache();
        this.invalidateCollectionAreaCache();
    }

    public void drops() {
        SimpleContainer outputInv = new SimpleContainer(this.outputInventory.getSlots());
        for (int i = 0; i < this.outputInventory.getSlots(); ++i) {
            outputInv.setItem(i, this.outputInventory.getStackInSlot(i));
            this.outputInventory.setStackInSlot(i, ItemStack.EMPTY);
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)outputInv);
        SimpleContainer moduleInv = new SimpleContainer(this.moduleSlots.getSlots());
        for (int i = 0; i < this.moduleSlots.getSlots(); ++i) {
            moduleInv.setItem(i, this.moduleSlots.getStackInSlot(i));
            this.moduleSlots.setStackInSlot(i, ItemStack.EMPTY);
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)moduleInv);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        try {
            tag.put("moduleSlots", (Tag)this.moduleSlots.serializeNBT(registries));
        }
        catch (Exception e) {
            LOGGER.error("Failed to serialize module slots for collector at {}", (Object)this.getBlockPos(), (Object)e);
        }
        try {
            tag.put("outputInventory", (Tag)this.outputInventory.serializeNBT(registries));
        }
        catch (Exception e) {
            LOGGER.error("Failed to serialize output inventory for collector at {}", (Object)this.getBlockPos(), (Object)e);
        }
        tag.putInt("storedXP", this.storedXP);
        tag.putBoolean("xpCollectionEnabled", this.xpCollectionEnabled);
        tag.putInt("downUpOffset", this.downUpOffset);
        tag.putInt("northSouthOffset", this.northSouthOffset);
        tag.putInt("eastWestOffset", this.eastWestOffset);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        block11: {
            int i;
            int oldSize;
            block10: {
                super.loadAdditional(tag, registries);
                try {
                    if (!tag.contains("moduleSlots")) break block10;
                    CompoundTag moduleTag = tag.getCompound("moduleSlots");
                    oldSize = moduleTag.getInt("Size");
                    if (oldSize == this.moduleSlots.getSlots()) {
                        this.moduleSlots.deserializeNBT(registries, moduleTag);
                    } else {
                        this.migrateModuleSlots(moduleTag, registries, oldSize);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to deserialize module slots for collector at {}, resetting to empty", (Object)this.getBlockPos(), (Object)e);
                    for (i = 0; i < this.moduleSlots.getSlots(); ++i) {
                        this.moduleSlots.setStackInSlot(i, ItemStack.EMPTY);
                    }
                }
            }
            try {
                if (!tag.contains("outputInventory")) break block11;
                CompoundTag outputTag = tag.getCompound("outputInventory");
                oldSize = outputTag.getInt("Size");
                if (oldSize == this.outputInventory.getSlots()) {
                    this.outputInventory.deserializeNBT(registries, outputTag);
                } else {
                    this.migrateOutputInventory(outputTag, registries, oldSize);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to deserialize output inventory for collector at {}, resetting to empty", (Object)this.getBlockPos(), (Object)e);
                for (i = 0; i < this.outputInventory.getSlots(); ++i) {
                    this.outputInventory.setStackInSlot(i, ItemStack.EMPTY);
                }
            }
        }
        this.storedXP = tag.getInt("storedXP");
        this.xpCollectionEnabled = tag.getBoolean("xpCollectionEnabled");
        this.downUpOffset = tag.getInt("downUpOffset");
        this.northSouthOffset = tag.getInt("northSouthOffset");
        this.eastWestOffset = tag.getInt("eastWestOffset");
        this.invalidateAllCaches();
    }

    private void migrateModuleSlots(CompoundTag oldTag, HolderLookup.Provider registries, int oldSize) {
        for (int i = 0; i < this.moduleSlots.getSlots(); ++i) {
            this.moduleSlots.setStackInSlot(i, ItemStack.EMPTY);
        }
        int maxSlots = Math.min(oldSize, this.moduleSlots.getSlots());
        for (int i = 0; i < maxSlots; ++i) {
            String key = String.valueOf(i);
            if (!oldTag.contains(key)) continue;
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)oldTag.getCompound(key));
            if (this.moduleSlots.isItemValid(i, stack)) {
                this.moduleSlots.setStackInSlot(i, stack);
                continue;
            }
            if (this.level == null || stack.isEmpty()) continue;
            Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)stack);
        }
    }

    private void migrateOutputInventory(CompoundTag oldTag, HolderLookup.Provider registries, int oldSize) {
        String key;
        int i;
        for (int i2 = 0; i2 < this.outputInventory.getSlots(); ++i2) {
            this.outputInventory.setStackInSlot(i2, ItemStack.EMPTY);
        }
        int maxSlots = Math.min(oldSize, this.outputInventory.getSlots());
        for (i = 0; i < maxSlots; ++i) {
            key = String.valueOf(i);
            if (!oldTag.contains(key)) continue;
            this.outputInventory.setStackInSlot(i, ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)oldTag.getCompound(key)));
        }
        for (i = this.outputInventory.getSlots(); i < oldSize; ++i) {
            ItemStack stack;
            key = String.valueOf(i);
            if (!oldTag.contains(key) || this.level == null || (stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)oldTag.getCompound(key))).isEmpty()) continue;
            Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)stack);
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"menu.mobflowutilities.collector");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new CollectorMenu(i, inventory, this);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        try {
            return this.saveWithoutMetadata(registries);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create update tag for collector at {}", (Object)this.getBlockPos(), (Object)e);
            CompoundTag tag = new CompoundTag();
            tag.putString("id", MFUBlockEntities.COLLECTOR_BE.get().toString());
            return tag;
        }
    }

    public void tick() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= 5) {
            this.tickCounter = 0;
            this.collectItems();
            if (this.xpCollectionEnabled) {
                this.collectXP();
            }
        }
    }

    private void collectItems() {
        AABB area = this.getCollectionArea();
        List items = this.level.getEntitiesOfClass(ItemEntity.class, area);
        for (ItemEntity item : items) {
            if (!item.isAlive() || item.hasPickUpDelay()) continue;
            ItemStack stack = item.getItem().copy();
            if (this.shouldVoidItem(stack)) {
                ItemStack current;
                int amount = stack.getCount();
                if (amount >= (current = item.getItem()).getCount()) {
                    item.discard();
                    continue;
                }
                item.setItem(current.copyWithCount(current.getCount() - amount));
                continue;
            }
            ItemStack remaining = this.insertIntoInventory(stack);
            int inserted = stack.getCount() - remaining.getCount();
            if (inserted <= 0) continue;
            ItemStack current = item.getItem();
            if (inserted >= current.getCount()) {
                item.discard();
                continue;
            }
            item.setItem(current.copyWithCount(current.getCount() - inserted));
        }
    }

    private boolean shouldVoidItem(ItemStack stack) {
        for (int i = 1; i <= 3; ++i) {
            VoidFilterData data;
            ItemStack module = this.moduleSlots.getStackInSlot(i);
            if (!(module.getItem() instanceof VoidFilterItem) || !(data = (VoidFilterData)module.getOrDefault((DataComponentType)MFUDataComponents.VOID_FILTER_DATA.get(), (Object)VoidFilterData.DEFAULT)).shouldVoidItem(stack)) continue;
            return true;
        }
        return false;
    }

    private void collectXP() {
        AABB area = this.getCollectionArea();
        List orbs = this.level.getEntitiesOfClass(ExperienceOrb.class, area);
        int collected = 0;
        for (ExperienceOrb orb : orbs) {
            if (!orb.isAlive()) continue;
            collected += orb.getValue();
            orb.discard();
        }
        if (collected > 0) {
            this.storedXP += collected;
            this.setChangedAndUpdate();
        }
    }

    private AABB getCollectionArea() {
        if (this.collectionAreaDirty || this.cachedCollectionArea == null) {
            int r = this.getPickupRange();
            BlockPos pos = this.getBlockPos();
            this.cachedCollectionArea = new AABB((double)(pos.getX() - r + this.eastWestOffset), (double)(pos.getY() - r + this.downUpOffset), (double)(pos.getZ() - r + this.northSouthOffset), (double)(pos.getX() + r + 1 + this.eastWestOffset), (double)(pos.getY() + r + 1 + this.downUpOffset), (double)(pos.getZ() + r + 1 + this.northSouthOffset));
            this.collectionAreaDirty = false;
        }
        return this.cachedCollectionArea;
    }

    private ItemStack insertIntoInventory(ItemStack stack) {
        for (int i = 0; i < this.outputInventory.getSlots() && !(stack = this.outputInventory.insertItem(i, stack, false)).isEmpty(); ++i) {
        }
        return stack;
    }

    private void setChangedAndUpdate() {
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> createTicker() {
        return (level, pos, state, blockEntity) -> {
            if (blockEntity instanceof CollectorBlockEntity) {
                CollectorBlockEntity collector = (CollectorBlockEntity)blockEntity;
                collector.tick();
            }
        };
    }
}

