/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.entity;

import com.misterd.mobflowutilities.block.MFUBlocks;
import com.misterd.mobflowutilities.entity.custom.CollectorBlockEntity;
import com.misterd.mobflowutilities.entity.custom.ControllerBlockEntity;
import com.misterd.mobflowutilities.entity.custom.DamagePadBlockEntity;
import com.misterd.mobflowutilities.entity.custom.FanBlockEntity;
import com.misterd.mobflowutilities.entity.custom.FlowPadBlockEntity;
import com.misterd.mobflowutilities.entity.custom.GenesisChamberBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class MFUBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"mobflowutilities");
    public static final Supplier<BlockEntityType<ControllerBlockEntity>> CONTROLLER_BE = BLOCK_ENTITIES.register("controller_be", () -> BlockEntityType.Builder.of(ControllerBlockEntity::new, (Block[])new Block[]{(Block)MFUBlocks.CONTROLLER.get()}).build(null));
    public static final Supplier<BlockEntityType<CollectorBlockEntity>> COLLECTOR_BE = BLOCK_ENTITIES.register("collector_be", () -> BlockEntityType.Builder.of(CollectorBlockEntity::new, (Block[])new Block[]{(Block)MFUBlocks.COLLECTOR.get()}).build(null));
    public static final Supplier<BlockEntityType<FanBlockEntity>> FAN_BE = BLOCK_ENTITIES.register("fan_be", () -> BlockEntityType.Builder.of(FanBlockEntity::new, (Block[])new Block[]{(Block)MFUBlocks.FAN.get()}).build(null));
    public static final Supplier<BlockEntityType<DamagePadBlockEntity>> DAMAGE_PAD_BE = BLOCK_ENTITIES.register("damage_pad_be", () -> BlockEntityType.Builder.of(DamagePadBlockEntity::new, (Block[])new Block[]{(Block)MFUBlocks.DAMAGE_PAD.get()}).build(null));
    public static final Supplier<BlockEntityType<FlowPadBlockEntity>> FLOW_PAD_BE = BLOCK_ENTITIES.register("flow_pad_be", () -> BlockEntityType.Builder.of(FlowPadBlockEntity::new, (Block[])new Block[]{(Block)MFUBlocks.FAST_FLOW_PAD.get(), (Block)MFUBlocks.FASTER_FLOW_PAD.get(), (Block)MFUBlocks.FASTEST_FLOW_PAD.get()}).build(null));
    public static final Supplier<BlockEntityType<GenesisChamberBlockEntity>> GENESIS_CHAMBER_BE = BLOCK_ENTITIES.register("genesis_chamber_be", () -> BlockEntityType.Builder.of(GenesisChamberBlockEntity::new, (Block[])new Block[]{(Block)MFUBlocks.GENESIS_CHAMBER.get()}).build(null));

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, COLLECTOR_BE.get(), (blockEntity, direction) -> {
            if (blockEntity instanceof CollectorBlockEntity) {
                CollectorBlockEntity collector = blockEntity;
                return collector.getItemHandler((Direction)direction);
            }
            return null;
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, CONTROLLER_BE.get(), (blockEntity, direction) -> {
            if (blockEntity instanceof ControllerBlockEntity) {
                ControllerBlockEntity controller = blockEntity;
                return controller.inventory;
            }
            return null;
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, GENESIS_CHAMBER_BE.get(), (blockEntity, direction) -> {
            if (blockEntity instanceof GenesisChamberBlockEntity) {
                GenesisChamberBlockEntity genesisChamber = blockEntity;
                return genesisChamber.getItemHandler((Direction)direction);
            }
            return null;
        });
    }

    public static void register(IEventBus eventBus) {
        BLOCK_ENTITIES.register(eventBus);
        eventBus.addListener(MFUBlockEntities::registerCapabilities);
    }
}

