/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.datagen.custom;

import com.misterd.mobflowutilities.item.MFUItems;
import com.misterd.mobflowutilities.loot.AddItemModifier;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import net.neoforged.neoforge.registries.DeferredItem;

public class MFUGlobalLootModifierProvider
extends GlobalLootModifierProvider {
    private static final String MOD_ID = "mobflowutilities";

    public MFUGlobalLootModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, MOD_ID);
    }

    protected void start() {
        String[] allMobs;
        String[] friendlyChests;
        String[] passiveMobs;
        String[] hostileChests;
        String[] hostileMobs;
        for (String mob : hostileMobs = new String[]{"entities/wither_skeleton", "entities/skeleton", "entities/zombie", "entities/creeper", "entities/spider", "entities/cave_spider", "entities/enderman", "entities/stray", "entities/husk", "entities/drowned", "entities/blaze", "entities/magma_cube", "entities/ghast", "entities/phantom", "entities/pillager", "entities/vindicator", "entities/evoker", "entities/witch", "entities/bat", "entities/breeze", "entities/bogged"}) {
            this.addMobLoot("gloom_spore_from_" + mob.replace("entities/", ""), mob, MFUItems.GLOOM_SPORE, 0.005f);
        }
        for (String chest : hostileChests = new String[]{"chests/bastion_bridge", "chests/bastion_treasure", "chests/bastion_other", "chests/end_city_treasure", "chests/stronghold_corridor", "chests/stronghold_crossing", "chests/stronghold_library", "chests/pillager_outpost", "chests/nether_bridge", "chests/woodland_mansion"}) {
            this.addChestLoot("gloom_spore_from_" + chest.replace("chests/", ""), chest, MFUItems.GLOOM_SPORE, 0.3f);
        }
        for (String mob : passiveMobs = new String[]{"entities/rabbit", "entities/fox", "entities/horse", "entities/donkey", "entities/cow", "entities/sheep", "entities/chicken", "entities/pig", "entities/llama", "entities/trader_llama", "entities/cat", "entities/wolf", "entities/mooshroom", "entities/parrot", "entities/villager", "entities/wandering_trader", "entities/goat", "entities/strider", "entities/iron_golem"}) {
            this.addMobLoot("glimmer_sprout_from_" + mob.replace("entities/", ""), mob, MFUItems.GLIMMER_SPROUT, 0.005f);
        }
        for (String chest : friendlyChests = new String[]{"chests/village/village_plains_house", "chests/village/village_desert_house", "chests/village/village_savanna_house", "chests/village/village_snowy_house", "chests/village/village_taiga_house", "chests/village/village_armorer", "chests/village/village_cartographer", "chests/village/village_mason", "chests/village/village_toolsmith", "chests/village/village_weaponsmith", "chests/shipwreck_treasure", "chests/shipwreck_supply", "chests/buried_treasure", "chests/ruined_portal", "chests/jungle_temple", "chests/desert_pyramid"}) {
            this.addChestLoot("glimmer_sprout_from_" + chest.replace("chests/", ""), chest, MFUItems.GLIMMER_SPROUT, 0.3f);
        }
        for (String mob : allMobs = new String[]{"entities/wither_skeleton", "entities/skeleton", "entities/zombie", "entities/creeper", "entities/spider", "entities/cave_spider", "entities/enderman", "entities/stray", "entities/husk", "entities/drowned", "entities/blaze", "entities/magma_cube", "entities/ghast", "entities/phantom", "entities/pillager", "entities/vindicator", "entities/evoker", "entities/witch", "entities/bat", "entities/breeze", "entities/bogged", "entities/rabbit", "entities/fox", "entities/horse", "entities/donkey", "entities/cow", "entities/sheep", "entities/chicken", "entities/pig", "entities/llama", "entities/trader_llama", "entities/cat", "entities/wolf", "entities/mooshroom", "entities/parrot", "entities/villager", "entities/wandering_trader", "entities/goat", "entities/strider", "entities/iron_golem"}) {
            this.addMobLoot("incubation_crystal_from_" + mob.replace("entities/", ""), mob, MFUItems.INCUBATION_ORB, 1.0E-4f);
        }
        this.addBossLoot("glimmer_sprout_from_ender_dragon", "entities/ender_dragon", MFUItems.GLIMMER_SPROUT);
        this.addBossLoot("glimmer_sprout_from_elder_guardian", "entities/elder_guardian", MFUItems.GLIMMER_SPROUT);
        this.addBossLoot("gloom_spore_from_warden", "entities/warden", MFUItems.GLOOM_SPORE);
        this.addBossLoot("gloom_spore_from_wither", "entities/wither", MFUItems.GLOOM_SPORE);
        this.addBossLoot("gloom_spore_from_ravager", "entities/ravager", MFUItems.GLOOM_SPORE);
        this.addBossLoot("incubation_crystal_from_ender_dragon", "entities/ender_dragon", MFUItems.INCUBATION_ORB);
        this.addBossLoot("incubation_crystal_from_elder_guardian", "entities/elder_guardian", MFUItems.INCUBATION_ORB);
        this.addBossLoot("incubation_crystal_from_warden", "entities/warden", MFUItems.INCUBATION_ORB);
        this.addBossLoot("incubation_crystal_from_wither", "entities/wither", MFUItems.INCUBATION_ORB);
        this.addBossLoot("incubation_crystal_from_ravager", "entities/ravager", MFUItems.INCUBATION_ORB);
        String[] treasureChests = new String[]{"chests/village/village_armorer", "chests/village/village_mason", "chests/village/village_toolsmith", "chests/village/village_weaponsmith", "chests/shipwreck_treasure", "chests/shipwreck_supply", "chests/buried_treasure", "chests/ruined_portal", "chests/jungle_temple", "chests/desert_pyramid", "chests/bastion_bridge", "chests/bastion_treasure", "chests/bastion_other", "chests/end_city_treasure", "chests/stronghold_corridor", "chests/stronghold_crossing", "chests/stronghold_library", "chests/pillager_outpost", "chests/nether_bridge", "chests/woodland_mansion"};
    }

    private void addMobLoot(String name, String entityPath, DeferredItem<?> item, float chance) {
        this.add(name, (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(ResourceLocation.withDefaultNamespace((String)entityPath)).build(), LootItemRandomChanceCondition.randomChance((float)chance).build()}, (Item)item.get()), new ICondition[0]);
    }

    private void addChestLoot(String name, String chestPath, DeferredItem<?> item, float chance) {
        this.add(name, (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(ResourceLocation.withDefaultNamespace((String)chestPath)).build(), LootItemRandomChanceCondition.randomChance((float)chance).build()}, (Item)item.get()), new ICondition[0]);
    }

    private void addBossLoot(String name, String entityPath, DeferredItem<?> item) {
        this.add(name, (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(ResourceLocation.withDefaultNamespace((String)entityPath)).build()}, (Item)item.get()), new ICondition[0]);
    }
}

