/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.datagen;

import com.misterd.mobflowutilities.datagen.custom.MFUBlockStateProvider;
import com.misterd.mobflowutilities.datagen.custom.MFUBlockTagProvider;
import com.misterd.mobflowutilities.datagen.custom.MFUGlobalLootModifierProvider;
import com.misterd.mobflowutilities.datagen.custom.MFUItemModelProvider;
import com.misterd.mobflowutilities.datagen.custom.MFUItemTagProvider;
import com.misterd.mobflowutilities.datagen.custom.MFULootTableProvider;
import com.misterd.mobflowutilities.datagen.custom.MFURecipeProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="mobflowutilities", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(MFULootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new MFURecipeProvider(packOutput, lookupProvider));
        MFUBlockTagProvider blockTagsProvider = new MFUBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new MFUItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new MFUItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new MFUBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MFUGlobalLootModifierProvider(packOutput, lookupProvider));
    }
}

