/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.component.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public record VoidFilterData(List<ItemStack> filterItems, boolean ignoreNBT, boolean ignoreDurability) {
    public static final Codec<VoidFilterData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ItemStack.CODEC).optionalFieldOf("filterItems", List.of()).forGetter(data -> data.filterItems().stream().filter(stack -> !stack.isEmpty()).toList()), (App)Codec.BOOL.optionalFieldOf("ignoreNBT", (Object)true).forGetter(VoidFilterData::ignoreNBT), (App)Codec.BOOL.optionalFieldOf("ignoreDurability", (Object)true).forGetter(VoidFilterData::ignoreDurability)).apply((Applicative)instance, (items, ignoreNBT, ignoreDurability) -> {
        NonNullList fullList = NonNullList.withSize((int)45, (Object)ItemStack.EMPTY);
        for (int i = 0; i < Math.min(items.size(), 45); ++i) {
            fullList.set(i, (Object)((ItemStack)items.get(i)));
        }
        return new VoidFilterData((List<ItemStack>)fullList, (boolean)ignoreNBT, (boolean)ignoreDurability);
    }));
    public static final VoidFilterData DEFAULT = new VoidFilterData((List<ItemStack>)VoidFilterData.createEmptyFilterList(), true, true);

    private static NonNullList<ItemStack> createEmptyFilterList() {
        return NonNullList.withSize((int)45, (Object)ItemStack.EMPTY);
    }

    public void loadIntoHandler(ItemStackHandler handler) {
        for (int i = 0; i < Math.min(this.filterItems.size(), handler.getSlots()); ++i) {
            handler.setStackInSlot(i, this.filterItems.get(i).copy());
        }
    }

    public static VoidFilterData fromHandler(ItemStackHandler handler, boolean ignoreNBT, boolean ignoreDurability) {
        NonNullList items = NonNullList.withSize((int)handler.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < handler.getSlots(); ++i) {
            items.set(i, (Object)handler.getStackInSlot(i).copy());
        }
        return new VoidFilterData((List<ItemStack>)items, ignoreNBT, ignoreDurability);
    }

    public boolean shouldVoidItem(ItemStack itemToCheck) {
        if (itemToCheck.isEmpty()) {
            return false;
        }
        for (ItemStack filterItem : this.filterItems) {
            if (filterItem.isEmpty() || !this.itemsMatch(itemToCheck, filterItem)) continue;
            return true;
        }
        return false;
    }

    private boolean itemsMatch(ItemStack itemToCheck, ItemStack filterItem) {
        if (!itemToCheck.is(filterItem.getItem())) {
            return false;
        }
        if (this.ignoreNBT && this.ignoreDurability) {
            return true;
        }
        if (this.ignoreNBT) {
            return itemToCheck.getDamageValue() == filterItem.getDamageValue();
        }
        if (this.ignoreDurability) {
            ItemStack itemCopy = itemToCheck.copy();
            ItemStack filterCopy = filterItem.copy();
            itemCopy.setDamageValue(0);
            filterCopy.setDamageValue(0);
            return ItemStack.isSameItemSameComponents((ItemStack)itemCopy, (ItemStack)filterCopy);
        }
        return ItemStack.isSameItemSameComponents((ItemStack)itemToCheck, (ItemStack)filterItem);
    }
}

