/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.component.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;

public record PadWrenchData(OperationMode operationMode, SelectionMode selectionMode, @Nullable BlockPos selectedController, @Nullable BlockPos firstMultiPos) {
    public static final PadWrenchData DEFAULT = new PadWrenchData(OperationMode.ADD, SelectionMode.SINGLE, null, null);
    public static final Codec<PadWrenchData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OperationMode.CODEC.optionalFieldOf("operationMode", (Object)OperationMode.ADD).forGetter(PadWrenchData::operationMode), (App)SelectionMode.CODEC.optionalFieldOf("selectionMode", (Object)SelectionMode.SINGLE).forGetter(PadWrenchData::selectionMode), (App)BlockPos.CODEC.optionalFieldOf("selectedController").forGetter(data -> Optional.ofNullable(data.selectedController())), (App)BlockPos.CODEC.optionalFieldOf("firstMultiPos").forGetter(data -> Optional.ofNullable(data.firstMultiPos()))).apply((Applicative)instance, (opMode, selMode, controller, multiPos) -> new PadWrenchData((OperationMode)((Object)((Object)opMode)), (SelectionMode)((Object)((Object)selMode)), controller.orElse(null), multiPos.orElse(null))));

    public PadWrenchData withOperationMode(OperationMode operationMode) {
        return new PadWrenchData(operationMode, this.selectionMode, this.selectedController, this.firstMultiPos);
    }

    public PadWrenchData withSelectionMode(SelectionMode selectionMode) {
        return new PadWrenchData(this.operationMode, selectionMode, this.selectedController, this.firstMultiPos);
    }

    public PadWrenchData withSelectedController(@Nullable BlockPos selectedController) {
        return new PadWrenchData(this.operationMode, this.selectionMode, selectedController, this.firstMultiPos);
    }

    public PadWrenchData withFirstMultiPos(@Nullable BlockPos firstMultiPos) {
        return new PadWrenchData(this.operationMode, this.selectionMode, this.selectedController, firstMultiPos);
    }

    public static enum OperationMode {
        ADD,
        REMOVE;

        public static final Codec<OperationMode> CODEC;

        static {
            CODEC = Codec.stringResolver(Enum::name, name -> {
                try {
                    return OperationMode.valueOf(name.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return ADD;
                }
            });
        }
    }

    public static enum SelectionMode {
        SINGLE,
        MULTI;

        public static final Codec<SelectionMode> CODEC;

        static {
            CODEC = Codec.stringResolver(Enum::name, name -> {
                try {
                    return SelectionMode.valueOf(name.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return SINGLE;
                }
            });
        }
    }
}

