/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.client.renderer.ber;

import com.misterd.mobflowutilities.entity.custom.GenesisChamberBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;

public class GenesisChamberBlockEntityRenderer
implements BlockEntityRenderer<GenesisChamberBlockEntity> {
    private static final float CHAMBER_WIDTH = 0.75f;
    private static final float CHAMBER_HEIGHT = 0.55f;
    private static final float CHAMBER_DEPTH = 0.75f;

    public GenesisChamberBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(GenesisChamberBlockEntity genesisChamberBlockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack eggStack = genesisChamberBlockEntity.inventory.getStackInSlot(0);
        Item item = eggStack.getItem();
        if (!(item instanceof SpawnEggItem)) {
            return;
        }
        SpawnEggItem spawnEgg = (SpawnEggItem)item;
        EntityType type = spawnEgg.getType(eggStack);
        if (type == null) {
            return;
        }
        Entity entity = genesisChamberBlockEntity.getOrCreateRenderedEntity(type);
        if (entity == null) {
            return;
        }
        this.tickEntity(genesisChamberBlockEntity, entity);
        poseStack.pushPose();
        this.prepareEntityPose(entity, poseStack);
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        dispatcher.getRenderer(entity).render(entity, 0.0f, partialTicks, poseStack, buffer, combinedLight);
        poseStack.popPose();
    }

    private void tickEntity(GenesisChamberBlockEntity genesisChamberBlockEntity, Entity entity) {
        entity.tickCount = (int)genesisChamberBlockEntity.getLevel().getGameTime();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.tickCount % 2 == 0) {
                living.tick();
            }
        } else {
            entity.tick();
        }
    }

    private void prepareEntityPose(Entity entity, PoseStack poseStack) {
        poseStack.translate(0.5, 0.41, 0.5);
        float entityWidth = entity.getBbWidth();
        float entityHeight = entity.getBbHeight();
        float entityDepth = entity.getBbWidth();
        float paddingFactor = 0.8f;
        float scaleX = 0.75f * paddingFactor / entityWidth;
        float scaleY = 0.55f * paddingFactor / entityHeight;
        float scaleZ = 0.75f * paddingFactor / entityDepth;
        float scale = Math.min(Math.min(scaleX, scaleY), scaleZ);
        scale = Math.min(scale, 0.6f);
        poseStack.scale(scale, scale, scale);
        float rotation = ((float)entity.tickCount + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false)) * 2.0f;
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation % 360.0f));
    }
}

