/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.block.custom;

import com.misterd.mobflowutilities.block.MFUBlocks;
import com.misterd.mobflowutilities.config.Config;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;

public class GlimmerGrassBlock
extends Block {
    public GlimmerGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (!level.isClientSide()) {
            level.scheduleTick(pos, (Block)this, Config.getGlimmerGrassCheckInterval());
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        int lightLevel = level.getMaxLocalRawBrightness(pos.above());
        if (lightLevel >= 7) {
            this.attemptMobSpawning(level, pos, random);
        }
        level.scheduleTick(pos, (Block)this, Config.getGlimmerGrassCheckInterval());
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (Config.isGlimmerGrassParticlesEnabled() && random.nextInt(10) == 0) {
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() + 1.0;
            double z = (double)pos.getZ() + random.nextDouble();
            DustParticleOptions aquaDust = new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.8f), 1.0f);
            level.addParticle((ParticleOptions)aquaDust, x, y, z, 0.0, 0.05, 0.0);
        }
    }

    private void attemptMobSpawning(ServerLevel level, BlockPos pos, RandomSource random) {
        int centerX = pos.getX();
        int centerZ = pos.getZ();
        int minX = centerX - 8;
        int maxX = centerX + 8;
        int minZ = centerZ - 8;
        int maxZ = centerZ + 8;
        AABB spawnArea = new AABB((double)minX, (double)(pos.getY() - 5), (double)minZ, (double)maxX, (double)(pos.getY() + 5), (double)maxZ);
        long existingMobs = level.getEntitiesOfClass(Animal.class, spawnArea).size();
        if (existingMobs < (long)Config.getGlimmerGrassMobsPerArea()) {
            List passiveSpawns = ((Biome)level.getBiome(pos).value()).getMobSettings().getMobs(MobCategory.CREATURE).unwrap();
            if (passiveSpawns.isEmpty()) {
                passiveSpawns = ((Biome)level.getBiome(pos).value()).getMobSettings().getMobs(MobCategory.AMBIENT).unwrap();
            }
            int mobsToSpawn = Math.min(Config.getGlimmerGrassMobsPerArea() - (int)existingMobs, 3);
            for (int i = 0; i < mobsToSpawn; ++i) {
                MobSpawnSettings.SpawnerData spawnerData = (MobSpawnSettings.SpawnerData)passiveSpawns.get(random.nextInt(passiveSpawns.size()));
                EntityType entityType = spawnerData.type;
                BlockPos spawnPos = this.findSpawnPosition(level, minX, maxX, minZ, maxZ, pos.getY(), random);
                if (spawnPos == null) continue;
                try {
                    Mob mob = (Mob)entityType.create((Level)level);
                    if (mob == null) continue;
                    mob.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                    mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(spawnPos), MobSpawnType.NATURAL, null);
                    level.addFreshEntity((Entity)mob);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Failed to spawn passive mob: " + e.getMessage());
                }
            }
        }
    }

    private BlockPos findSpawnPosition(ServerLevel level, int minX, int maxX, int minZ, int maxZ, int baseY, RandomSource random) {
        for (int attempts = 0; attempts < 10; ++attempts) {
            int x = random.nextIntBetweenInclusive(minX, maxX);
            int z = random.nextIntBetweenInclusive(minZ, maxZ);
            for (int yOffset = -2; yOffset <= 2; ++yOffset) {
                int lightLevel;
                BlockPos checkPos = new BlockPos(x, baseY + yOffset, z);
                BlockPos abovePos = checkPos.above();
                if (level.getBlockState(checkPos).getBlock() != this || !level.getBlockState(abovePos).isAir() && !this.flowPadsAllowed(level.getBlockState(abovePos).getBlock()) || !level.getBlockState(abovePos.above()).isAir() || !level.getBlockState(checkPos).isFaceSturdy((BlockGetter)level, checkPos, Direction.UP) || (lightLevel = level.getMaxLocalRawBrightness(abovePos)) < 7) continue;
                return abovePos;
            }
        }
        return null;
    }

    private boolean flowPadsAllowed(Block block) {
        return block == MFUBlocks.FAST_FLOW_PAD.get() || block == MFUBlocks.FASTER_FLOW_PAD.get() || block == MFUBlocks.FASTEST_FLOW_PAD.get();
    }
}

