/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.block.custom;

import com.misterd.mobflowutilities.block.MFUBlocks;
import com.misterd.mobflowutilities.config.Config;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;

public class DarkDirtBlock
extends Block {
    public DarkDirtBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (!level.isClientSide()) {
            level.scheduleTick(pos, (Block)this, Config.getDarkDirtCheckInterval());
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean inDirectSunlight;
        super.tick(state, level, pos, random);
        boolean bl = inDirectSunlight = level.canSeeSky(pos.above()) && level.isDay();
        if (inDirectSunlight) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 3);
            return;
        }
        int lightLevel = level.getMaxLocalRawBrightness(pos.above());
        if (lightLevel == 0) {
            this.attemptMobSpawning(level, pos, random);
        }
        level.scheduleTick(pos, (Block)this, Config.getDarkDirtCheckInterval());
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (Config.isDarkDirtParticlesEnabled() && random.nextInt(10) == 0) {
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() + 1.0;
            double z = (double)pos.getZ() + random.nextDouble();
            DustParticleOptions grayDust = new DustParticleOptions(new Vector3f(0.3f, 0.3f, 0.3f), 1.0f);
            level.addParticle((ParticleOptions)grayDust, x, y, z, 0.0, 0.05, 0.0);
        }
    }

    private void attemptMobSpawning(ServerLevel level, BlockPos pos, RandomSource random) {
        List spawners;
        int maxZ;
        int minZ;
        int maxX;
        int minX;
        BlockPos spawnPos;
        int radius = 8;
        int searchRadius = radius * 2;
        AABB searchBox = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - 2), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + 2), (double)(pos.getZ() + radius));
        List nearbyMobs = level.getEntitiesOfClass(Mob.class, searchBox, mob -> mob.getType().getCategory() == MobCategory.MONSTER);
        if (nearbyMobs.size() < Config.getDarkDirtMobsPerArea() && (spawnPos = this.findSpawnPosition(level, minX = pos.getX() - searchRadius, maxX = pos.getX() + searchRadius, minZ = pos.getZ() - searchRadius, maxZ = pos.getZ() + searchRadius, pos.getY(), random)) != null && !(spawners = ((Biome)level.getBiome(spawnPos).value()).getMobSettings().getMobs(MobCategory.MONSTER).unwrap()).isEmpty()) {
            int totalWeight = spawners.stream().mapToInt(data -> data.getWeight().asInt()).sum();
            int randomWeight = random.nextInt(totalWeight);
            int cumulativeWeight = 0;
            for (MobSpawnSettings.SpawnerData spawner : spawners) {
                if (randomWeight >= (cumulativeWeight += spawner.getWeight().asInt())) continue;
                EntityType entityType = spawner.type;
                try {
                    Mob mob2 = (Mob)entityType.create((Level)level);
                    if (mob2 == null) break;
                    mob2.moveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, random.nextFloat() * 360.0f, 0.0f);
                    if (!SpawnPlacements.checkSpawnRules((EntityType)entityType, (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)spawnPos, (RandomSource)random)) break;
                    mob2.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(spawnPos), MobSpawnType.NATURAL, null);
                    level.addFreshEntity((Entity)mob2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    private BlockPos findSpawnPosition(ServerLevel level, int minX, int maxX, int minZ, int maxZ, int baseY, RandomSource random) {
        for (int attempts = 0; attempts < 10; ++attempts) {
            int x = random.nextIntBetweenInclusive(minX, maxX);
            int z = random.nextIntBetweenInclusive(minZ, maxZ);
            for (int yOffset = -2; yOffset <= 2; ++yOffset) {
                int lightLevel;
                BlockPos checkPos = new BlockPos(x, baseY + yOffset, z);
                BlockPos abovePos = checkPos.above();
                if (level.getBlockState(checkPos).getBlock() != this || !level.getBlockState(abovePos).isAir() && !this.flowPadsAllowed(level.getBlockState(abovePos).getBlock()) || !level.getBlockState(abovePos.above()).isAir() || !level.getBlockState(checkPos).isFaceSturdy((BlockGetter)level, checkPos, Direction.UP) || (lightLevel = level.getMaxLocalRawBrightness(abovePos)) != 0) continue;
                return abovePos;
            }
        }
        return null;
    }

    private boolean flowPadsAllowed(Block block) {
        return block == MFUBlocks.FAST_FLOW_PAD.get() || block == MFUBlocks.FASTER_FLOW_PAD.get() || block == MFUBlocks.FASTEST_FLOW_PAD.get();
    }
}

