/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.block.custom;

import com.misterd.mobflowutilities.component.MFUDataComponents;
import com.misterd.mobflowutilities.component.custom.PadWrenchData;
import com.misterd.mobflowutilities.entity.custom.ControllerBlockEntity;
import com.misterd.mobflowutilities.item.custom.PadWrenchItem;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ControllerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final MapCodec<ControllerBlock> CODEC = ControllerBlock.simpleCodec(ControllerBlock::new);

    public ControllerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ControllerBlockEntity(pos, state);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof ControllerBlockEntity) {
            ControllerBlockEntity controller = (ControllerBlockEntity)blockEntity;
            controller.clearAllLinkedPads();
            this.clearControllerFromNearbyWrenches(level, pos);
            controller.drops();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    private void clearControllerFromNearbyWrenches(Level level, BlockPos controllerPos) {
        if (!level.isClientSide()) {
            for (Player player : level.players()) {
                if (!(player.distanceToSqr((double)controllerPos.getX(), (double)controllerPos.getY(), (double)controllerPos.getZ()) <= 4096.0)) continue;
                this.clearControllerFromPlayerWrenches(player, controllerPos);
            }
        }
    }

    private void clearControllerFromPlayerWrenches(Player player, BlockPos controllerPos) {
        this.clearControllerFromHand(player.getMainHandItem(), controllerPos, player);
        this.clearControllerFromHand(player.getOffhandItem(), controllerPos, player);
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            this.clearControllerFromHand(player.getInventory().getItem(i), controllerPos, player);
        }
    }

    private void clearControllerFromHand(ItemStack stack, BlockPos controllerPos, Player player) {
        PadWrenchData data;
        if (stack.getItem() instanceof PadWrenchItem && (data = (PadWrenchData)stack.getOrDefault((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)PadWrenchData.DEFAULT)).selectedController() != null && data.selectedController().equals((Object)controllerPos)) {
            PadWrenchData newData = data.withSelectedController(null);
            stack.set((DataComponentType)MFUDataComponents.PAD_WRENCH_DATA.get(), (Object)newData);
            player.displayClientMessage((Component)Component.translatable((String)"item.mobflowutilities.pad_wrench.controller.cleared"), true);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ControllerBlockEntity) {
            ControllerBlockEntity controller = (ControllerBlockEntity)blockEntity;
            if (!level.isClientSide() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)controller, (Component)Component.translatable((String)"gui.mobflowutilities.controller")), pos);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }
}

