/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities.block;

import com.misterd.mobflowutilities.block.custom.CollectorBlock;
import com.misterd.mobflowutilities.block.custom.ControllerBlock;
import com.misterd.mobflowutilities.block.custom.DamagePadBlock;
import com.misterd.mobflowutilities.block.custom.DarkDirtBlock;
import com.misterd.mobflowutilities.block.custom.FanBlock;
import com.misterd.mobflowutilities.block.custom.FastFlowPadBlock;
import com.misterd.mobflowutilities.block.custom.FasterFlowPadBlock;
import com.misterd.mobflowutilities.block.custom.FastestFlowPadBlock;
import com.misterd.mobflowutilities.block.custom.GenesisChamberBlock;
import com.misterd.mobflowutilities.block.custom.GlimmerGrassBlock;
import com.misterd.mobflowutilities.block.custom.GlimmerLampBlock;
import com.misterd.mobflowutilities.item.MFUItems;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class MFUBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"mobflowutilities");
    public static final DeferredBlock<Block> FAST_FLOW_PAD = MFUBlocks.registerBlock("flow_pad_fast", () -> new FastFlowPadBlock(BlockBehaviour.Properties.of().strength(3.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE)));
    public static final DeferredBlock<Block> FASTER_FLOW_PAD = MFUBlocks.registerBlock("flow_pad_faster", () -> new FasterFlowPadBlock(BlockBehaviour.Properties.of().strength(3.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE)));
    public static final DeferredBlock<Block> FASTEST_FLOW_PAD = MFUBlocks.registerBlock("flow_pad_fastest", () -> new FastestFlowPadBlock(BlockBehaviour.Properties.of().strength(3.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE)));
    public static final DeferredBlock<Block> DAMAGE_PAD = MFUBlocks.registerBlock("damage_pad", () -> new DamagePadBlock(BlockBehaviour.Properties.of().strength(3.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE)));
    public static final DeferredBlock<Block> DARK_DIRT = MFUBlocks.registerBlock("dark_dirt", () -> new DarkDirtBlock(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.GRASS)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"block.mobflowutilities.dark_dirt.subtitle").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    });
    public static final DeferredBlock<Block> GLIMMER_GRASS = MFUBlocks.registerBlock("glimmer_grass", () -> new GlimmerGrassBlock(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.GRASS)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"block.mobflowutilities.glimmer_grass.subtitle").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    });
    public static final DeferredBlock<Block> DARK_GLASS = MFUBlocks.registerBlock("dark_glass", () -> new TintedGlassBlock(BlockBehaviour.Properties.of().strength(2.0f, 5000000.0f).requiresCorrectToolForDrops().sound(SoundType.GLASS).noOcclusion()){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"block.mobflowutilities.dark_glass.subtitle").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    });
    public static final DeferredBlock<Block> GLIMMER_LAMP = MFUBlocks.registerBlock("glimmer_lamp", () -> new GlimmerLampBlock(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.GLASS).lightLevel(state -> (Boolean)state.getValue((Property)GlimmerLampBlock.LIT) != false ? 15 : 0)));
    public static final DeferredBlock<Block> COLLECTOR = MFUBlocks.registerBlock("collector", () -> new CollectorBlock(BlockBehaviour.Properties.of().strength(3.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.STONE).noLootTable()));
    public static final DeferredBlock<Block> CONTROLLER = MFUBlocks.registerBlock("controller", () -> new ControllerBlock(BlockBehaviour.Properties.of().strength(3.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> FAN = MFUBlocks.registerBlock("fan", () -> new FanBlock(BlockBehaviour.Properties.of().strength(3.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.STONE)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"block.mobflowutilities.fan.subtitle_line1").withStyle(ChatFormatting.LIGHT_PURPLE));
            tooltipComponents.add((Component)Component.translatable((String)"block.mobflowutilities.fan.subtitle_line2").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    });
    public static final DeferredBlock<Block> GENESIS_CHAMBER = MFUBlocks.registerBlock("genesis_chamber", () -> new GenesisChamberBlock(BlockBehaviour.Properties.of().strength(2.0f).requiresCorrectToolForDrops().sound(SoundType.STONE).noOcclusion()){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"block.mobflowutilities.genesis_chamber.subtitle").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    });

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        MFUBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        MFUItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

