/*
 * Decompiled with CFR 0.152.
 */
package com.misterd.mobflowutilities;

import com.misterd.mobflowutilities.block.MFUBlocks;
import com.misterd.mobflowutilities.client.renderer.ber.GenesisChamberBlockEntityRenderer;
import com.misterd.mobflowutilities.component.MFUDataComponents;
import com.misterd.mobflowutilities.config.Config;
import com.misterd.mobflowutilities.entity.MFUBlockEntities;
import com.misterd.mobflowutilities.gui.MFUMenuTypes;
import com.misterd.mobflowutilities.gui.custom.CollectorScreen;
import com.misterd.mobflowutilities.gui.custom.ControllerScreen;
import com.misterd.mobflowutilities.gui.custom.FanScreen;
import com.misterd.mobflowutilities.gui.custom.GenesisChamberScreen;
import com.misterd.mobflowutilities.gui.custom.VoidFilterScreen;
import com.misterd.mobflowutilities.item.MFUCreativeTab;
import com.misterd.mobflowutilities.item.MFUItems;
import com.misterd.mobflowutilities.loot.MFULootModifiers;
import com.misterd.mobflowutilities.network.MFUNetwork;
import com.misterd.mobflowutilities.recipe.MFURecipeSerializers;
import com.misterd.mobflowutilities.util.MFUItemProperties;
import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="mobflowutilities")
public class MobFlowUtilities {
    public static final String MODID = "mobflowutilities";
    public static final Logger LOGGER = LogUtils.getLogger();

    public MobFlowUtilities(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        MFUItems.register(modEventBus);
        MFUBlocks.register(modEventBus);
        MFUCreativeTab.register(modEventBus);
        MFULootModifiers.register(modEventBus);
        MFURecipeSerializers.register(modEventBus);
        MFUBlockEntities.register(modEventBus);
        MFUMenuTypes.register(modEventBus);
        MFUNetwork.register(modEventBus);
        MFUDataComponents.register(modEventBus);
        Config.register(modContainer);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="mobflowutilities", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)MFUBlocks.DARK_GLASS.get()), (RenderType)RenderType.translucent());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)MFUBlocks.GENESIS_CHAMBER.get()), (RenderType)RenderType.translucent());
            });
            MFUItemProperties.addCustomItemProperties();
        }

        @SubscribeEvent
        public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        }

        @SubscribeEvent
        public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(MFUBlockEntities.GENESIS_CHAMBER_BE.get(), GenesisChamberBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)MFUMenuTypes.COLLECTOR_MENU.get(), CollectorScreen::new);
            event.register((MenuType)MFUMenuTypes.VOID_FILTER_MENU.get(), VoidFilterScreen::new);
            event.register((MenuType)MFUMenuTypes.CONTROLLER_MENU.get(), ControllerScreen::new);
            event.register((MenuType)MFUMenuTypes.GENESIS_CHAMBER_MENU.get(), GenesisChamberScreen::new);
            event.register((MenuType)MFUMenuTypes.FAN_MENU.get(), FanScreen::new);
        }
    }
}

