/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.core;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import website.eccentric.tome.EccentricDataComponents;
import website.eccentric.tome.EccentricTome;
import website.eccentric.tome.TomeItem;
import website.eccentric.tome.core.TomeCore;
import website.eccentric.tome.core.TomeData;

public class TomeManager {
    private static final String ACTIVE_BOOK_MOD = "active_book_mod";
    private static final String ACTIVE_BOOK_INDEX = "active_book_index";

    public static ItemStack createTome() {
        ItemStack tome = new ItemStack((ItemLike)EccentricTome.TOME.get());
        tome.set(EccentricDataComponents.TOME_DATA.get(), (Object)TomeData.EMPTY);
        return tome;
    }

    public static ItemStack addBookToTome(ItemStack tome, ItemStack book) {
        if (!TomeManager.isTome(tome) || book.isEmpty()) {
            return tome;
        }
        TomeData data = (TomeData)tome.getOrDefault(EccentricDataComponents.TOME_DATA.get(), (Object)TomeData.EMPTY);
        TomeData newData = data.withBook(book);
        if (newData.equals(data)) {
            EccentricTome.LOGGER.debug("Book already exists in tome");
            return tome;
        }
        ItemStack result = tome.copy();
        result.set(EccentricDataComponents.TOME_DATA.get(), (Object)newData);
        return result;
    }

    public static ItemStack selectBook(ItemStack tome, String modId, int index) {
        if (!TomeManager.isTome(tome)) {
            return ItemStack.EMPTY;
        }
        TomeData data = (TomeData)tome.getOrDefault(EccentricDataComponents.TOME_DATA.get(), (Object)TomeData.EMPTY);
        TomeCore core = data.toCore();
        ItemStack book = core.getBook(modId, index);
        if (book.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack activeBook = book.copy();
        activeBook.set(EccentricDataComponents.TOME_DATA.get(), (Object)data);
        activeBook.set(EccentricDataComponents.IS_ACTIVE_BOOK.get(), (Object)true);
        activeBook.set(EccentricDataComponents.ACTIVE_MOD.get(), (Object)modId);
        activeBook.set(EccentricDataComponents.ACTIVE_INDEX.get(), (Object)index);
        TomeManager.setBookDisplayName(activeBook);
        return activeBook;
    }

    public static ItemStack revertToTome(ItemStack book) {
        if (!TomeManager.isActiveBook(book)) {
            return ItemStack.EMPTY;
        }
        TomeData data = (TomeData)book.get(EccentricDataComponents.TOME_DATA.get());
        if (data == null) {
            return ItemStack.EMPTY;
        }
        ItemStack tome = TomeManager.createTome();
        tome.set(EccentricDataComponents.TOME_DATA.get(), (Object)data);
        return tome;
    }

    public static ItemStack extractBook(ItemStack activeBook, boolean keepTome) {
        if (!TomeManager.isActiveBook(activeBook)) {
            return ItemStack.EMPTY;
        }
        TomeData data = (TomeData)activeBook.get(EccentricDataComponents.TOME_DATA.get());
        String modId = (String)activeBook.get(EccentricDataComponents.ACTIVE_MOD.get());
        Integer index = (Integer)activeBook.get(EccentricDataComponents.ACTIVE_INDEX.get());
        if (data == null || modId == null || index == null) {
            return ItemStack.EMPTY;
        }
        TomeData updatedData = data.withoutBook(modId, index);
        ItemStack cleanBook = activeBook.copy();
        cleanBook.remove(EccentricDataComponents.TOME_DATA.get());
        cleanBook.remove(EccentricDataComponents.IS_ACTIVE_BOOK.get());
        cleanBook.remove(EccentricDataComponents.ACTIVE_MOD.get());
        cleanBook.remove(EccentricDataComponents.ACTIVE_INDEX.get());
        cleanBook.remove(DataComponents.CUSTOM_NAME);
        if (keepTome) {
            ItemStack tome = TomeManager.createTome();
            tome.set(EccentricDataComponents.TOME_DATA.get(), (Object)updatedData);
            return tome;
        }
        return cleanBook;
    }

    public static boolean isTome(ItemStack stack) {
        return !stack.isEmpty() && stack.getItem() instanceof TomeItem;
    }

    public static boolean isActiveBook(ItemStack stack) {
        return !stack.isEmpty() && Boolean.TRUE.equals(stack.get(EccentricDataComponents.IS_ACTIVE_BOOK.get()));
    }

    @Nullable
    public static InteractionHand getTomeHand(Player player) {
        ItemStack mainHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (TomeManager.isTome(mainHand)) {
            return InteractionHand.MAIN_HAND;
        }
        ItemStack offHand = player.getItemInHand(InteractionHand.OFF_HAND);
        if (TomeManager.isTome(offHand)) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    @Nullable
    public static InteractionHand getBookHand(Player player) {
        ItemStack mainHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (TomeManager.isActiveBook(mainHand)) {
            return InteractionHand.MAIN_HAND;
        }
        ItemStack offHand = player.getItemInHand(InteractionHand.OFF_HAND);
        if (TomeManager.isActiveBook(offHand)) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    private static void setBookDisplayName(ItemStack book) {
        MutableComponent name = book.getHoverName().copy().withStyle(ChatFormatting.GREEN);
        book.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"eccentrictome.name", (Object[])new Object[]{name}));
    }
}

