/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.core;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import website.eccentric.tome.core.TomeCore;

public record TomeData(UUID tomeId, Map<String, List<ItemStack>> books) {
    public static final TomeData EMPTY = new TomeData(UUID.randomUUID(), new HashMap<String, List<ItemStack>>());
    public static final Codec<TomeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(UUID::fromString, UUID::toString).fieldOf("tome_id").forGetter(TomeData::tomeId), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ItemStack.CODEC.listOf()).fieldOf("books").forGetter(TomeData::books)).apply((Applicative)instance, TomeData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TomeData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.map(UUID::fromString, UUID::toString), TomeData::tomeId, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), (int)256), TomeData::books, TomeData::new);

    public static TomeData fromCore(TomeCore core) {
        HashMap<String, List<ItemStack>> bookMap = new HashMap<String, List<ItemStack>>();
        for (String modId : core.getModIds()) {
            List modBooks = core.getBooksForMod(modId).stream().map(TomeCore.StoredBook::toItemStack).collect(Collectors.toList());
            bookMap.put(modId, modBooks);
        }
        return new TomeData(core.getId(), bookMap);
    }

    public TomeCore toCore() {
        HashMap<String, List<TomeCore.StoredBook>> coreBooks = new HashMap<String, List<TomeCore.StoredBook>>();
        for (Map.Entry<String, List<ItemStack>> entry : this.books.entrySet()) {
            List modBooks = entry.getValue().stream().map(TomeCore.StoredBook::new).collect(Collectors.toList());
            coreBooks.put(entry.getKey(), modBooks);
        }
        return new TomeCore(this.tomeId, coreBooks);
    }

    public TomeData withoutBook(String modId, int index) {
        TomeCore core = this.toCore();
        core.extractBook(modId, index);
        return TomeData.fromCore(core);
    }

    public TomeData withBook(ItemStack book) {
        TomeCore core = this.toCore();
        core.addBook(book);
        return TomeData.fromCore(core);
    }

    public int getTotalBookCount() {
        return this.books.values().stream().mapToInt(List::size).sum();
    }

    public boolean isEmpty() {
        return this.books.isEmpty();
    }
}

