/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class TomeCore {
    private final UUID tomeId;
    private final Map<String, List<StoredBook>> books;

    public TomeCore() {
        this.tomeId = UUID.randomUUID();
        this.books = new HashMap<String, List<StoredBook>>();
    }

    public TomeCore(UUID tomeId, Map<String, List<StoredBook>> books) {
        this.tomeId = tomeId;
        this.books = new HashMap<String, List<StoredBook>>(books);
    }

    public UUID getId() {
        return this.tomeId;
    }

    public boolean addBook(ItemStack book) {
        if (book.isEmpty()) {
            return false;
        }
        String modId = book.getItem().getCreatorModId(book);
        StoredBook storedBook = new StoredBook(book);
        List modBooks = this.books.computeIfAbsent(modId, k -> new ArrayList());
        for (StoredBook existing : modBooks) {
            if (!existing.matches(book)) continue;
            return false;
        }
        modBooks.add(storedBook);
        return true;
    }

    public ItemStack extractBook(String modId, int index) {
        List<StoredBook> modBooks = this.books.get(modId);
        if (modBooks == null || index < 0 || index >= modBooks.size()) {
            return ItemStack.EMPTY;
        }
        StoredBook book = modBooks.remove(index);
        if (modBooks.isEmpty()) {
            this.books.remove(modId);
        }
        return book.toItemStack();
    }

    public ItemStack getBook(String modId, int index) {
        List<StoredBook> modBooks = this.books.get(modId);
        if (modBooks == null || index < 0 || index >= modBooks.size()) {
            return ItemStack.EMPTY;
        }
        return modBooks.get(index).toItemStack();
    }

    public List<ItemStack> getAllBooks() {
        ArrayList<ItemStack> allBooks = new ArrayList<ItemStack>();
        for (List<StoredBook> modBooks : this.books.values()) {
            for (StoredBook book : modBooks) {
                allBooks.add(book.toItemStack());
            }
        }
        return allBooks;
    }

    public Set<String> getModIds() {
        return new HashSet<String>(this.books.keySet());
    }

    public List<StoredBook> getBooksForMod(String modId) {
        return this.books.getOrDefault(modId, Collections.emptyList());
    }

    public int getTotalBookCount() {
        return this.books.values().stream().mapToInt(List::size).sum();
    }

    public boolean isEmpty() {
        return this.books.isEmpty();
    }

    public TomeCore copy() {
        HashMap<String, List<StoredBook>> copiedBooks = new HashMap<String, List<StoredBook>>();
        for (Map.Entry<String, List<StoredBook>> entry : this.books.entrySet()) {
            copiedBooks.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return new TomeCore(this.tomeId, copiedBooks);
    }

    public static class StoredBook {
        private final ResourceLocation itemId;
        private final ItemStack cachedStack;

        public StoredBook(ItemStack stack) {
            this.itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            this.cachedStack = stack.copyWithCount(1);
        }

        public ItemStack toItemStack() {
            return this.cachedStack.copy();
        }

        public boolean matches(ItemStack stack) {
            if (stack.isEmpty()) {
                return false;
            }
            ResourceLocation otherId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            if (!this.itemId.equals((Object)otherId)) {
                return false;
            }
            return ItemStack.isSameItemSameComponents((ItemStack)this.cachedStack, (ItemStack)stack);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StoredBook)) {
                return false;
            }
            StoredBook other = (StoredBook)obj;
            return this.itemId.equals((Object)other.itemId) && ItemStack.isSameItemSameComponents((ItemStack)this.cachedStack, (ItemStack)other.cachedStack);
        }

        public int hashCode() {
            return Objects.hash(this.itemId);
        }
    }
}

