/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import website.eccentric.tome.AttachmentRecipe;
import website.eccentric.tome.EccentricConfig;
import website.eccentric.tome.EccentricDataComponents;
import website.eccentric.tome.TomeItem;
import website.eccentric.tome.core.TomeManager;
import website.eccentric.tome.network.RevertToTomePacket;

@Mod(value="eccentrictome")
public class EccentricTome {
    public static final String ID = "eccentrictome";
    public static final Logger LOGGER = LogManager.getLogger((String)"eccentrictome");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"eccentrictome");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"eccentrictome");
    public static final Supplier<RecipeSerializer<?>> ATTACHMENT = RECIPES.register("attachment", () -> new SimpleCraftingRecipeSerializer(AttachmentRecipe::new));
    public static final DeferredItem<Item> TOME = ITEMS.register("tome", TomeItem::new);

    public EccentricTome(IEventBus modEvent, ModContainer container) {
        ITEMS.register(modEvent);
        RECIPES.register(modEvent);
        EccentricDataComponents.COMPONENTS.register(modEvent);
        modEvent.addListener(this::onClientSetup);
        modEvent.addListener(this::onModConfig);
        modEvent.addListener(this::onBuildCreativeModeTabContents);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EccentricConfig.SPEC);
        IEventBus minecraftEvent = NeoForge.EVENT_BUS;
        minecraftEvent.addListener(EventPriority.LOW, this::onItemDropped);
        minecraftEvent.addListener(this::onLeftClickEmpty);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
    }

    private void onModConfig(ModConfigEvent event) {
        EccentricConfig.ALIAS_MAP.clear();
        for (String alias : EccentricConfig.getAliases()) {
            String[] tokens = alias.split("=");
            EccentricConfig.ALIAS_MAP.put(tokens[0], tokens[1]);
        }
    }

    private void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (TomeManager.isActiveBook(stack)) {
            PacketDistributor.sendToServer((CustomPacketPayload)RevertToTomePacket.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void onItemDropped(ItemTossEvent event) {
        if (!event.getPlayer().isShiftKeyDown()) {
            return;
        }
        ItemEntity entity = event.getEntity();
        ItemStack stack = entity.getItem();
        if (TomeManager.isActiveBook(stack)) {
            Level level = entity.getCommandSenderWorld();
            if (!level.isClientSide) {
                ItemStack extractedBook = TomeManager.extractBook(stack, false);
                ItemStack tome = TomeManager.extractBook(stack, true);
                if (!extractedBook.isEmpty() && !tome.isEmpty()) {
                    entity.setItem(extractedBook);
                    level.addFreshEntity((Entity)new ItemEntity(level, entity.getX(), entity.getY(), entity.getZ(), tome));
                }
            }
        }
    }

    private void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(CreativeModeTabs.TOOLS_AND_UTILITIES)) {
            event.accept(TOME);
        }
    }
}

