/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import website.eccentric.tome.EccentricTome;

@EventBusSubscriber(modid="eccentrictome", bus=EventBusSubscriber.Bus.MOD)
public class EccentricConfig {
    public static final ModConfigSpec.BooleanValue DISABLE_OVERLAY;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> ITEMS;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> ALIASES;
    public static final HashMap<String, String> ALIAS_MAP;
    private static final List<String> allItems;
    private static final List<String> allAliases;
    public static final ModConfigSpec SPEC;
    private static final String GITHUB_BASE_URL = "https://raw.githubusercontent.com/Porting-Dead-Mods/EccentricTome-Updated/refs/heads/main/configs/";
    private static final String ITEMS_FILENAME = "items.txt";
    private static final String ALIASES_FILENAME = "aliases.txt";

    public static List<String> getWhitelistedItems() {
        return allItems;
    }

    public static List<String> getAliases() {
        return allAliases;
    }

    public static List<String> downloadListFromGithub(String filename) {
        ArrayList<String> downloadedList;
        block10: {
            String githubUrl = GITHUB_BASE_URL + filename;
            downloadedList = new ArrayList<String>();
            try {
                URL url = new URL(githubUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                if (connection.getResponseCode() == 200) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (line.isBlank() || line.startsWith("#")) continue;
                            downloadedList.add(line.trim());
                        }
                    }
                    EccentricTome.LOGGER.info("Successfully downloaded {} entries from {}", (Object)downloadedList.size(), (Object)filename);
                    break block10;
                }
                EccentricTome.LOGGER.error("Failed to download {}. HTTP code: {}", (Object)filename, (Object)connection.getResponseCode());
            }
            catch (Exception e) {
                EccentricTome.LOGGER.error("Error downloading {}: {}", (Object)filename, (Object)e.getMessage());
            }
        }
        return downloadedList;
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent event) {
        allItems.clear();
        allAliases.clear();
        ALIAS_MAP.clear();
        List<String> downloadedItems = EccentricConfig.downloadListFromGithub(ITEMS_FILENAME);
        allItems.addAll((Collection)ITEMS.get());
        allItems.addAll(downloadedItems);
        List<String> downloadedAliases = EccentricConfig.downloadListFromGithub(ALIASES_FILENAME);
        allAliases.addAll((Collection)ALIASES.get());
        allAliases.addAll(downloadedAliases);
        for (String alias : allAliases) {
            String[] parts = alias.split("=");
            if (parts.length != 2) continue;
            ALIAS_MAP.put(parts[0], parts[1]);
        }
        EccentricTome.LOGGER.info("Loaded {} items and {} aliases", (Object)allItems.size(), (Object)ALIAS_MAP.size());
    }

    static {
        ALIAS_MAP = new HashMap();
        allItems = new ArrayList<String>();
        allAliases = new ArrayList<String>();
        ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder().comment("Common configuration settings").push("common");
        DISABLE_OVERLAY = BUILDER.comment("Disable overlay previewing tome conversion").define("disable_overlay", false);
        ITEMS = BUILDER.comment("Whitelisted items").defineListAllowEmpty(List.of("items"), () -> List.of("actuallyadditions:booklet", "ad_astra:astrodux", "ae2:guide", "alexsmobs:animal_dictionary", "ars_nouveau:worn_notebook", "compactmachines:personal_shrinking_device", "cookingforblockheads:no_filter_edition", "draconicevolution:info_tablet", "enigmaticlegacy:the_acknowledgment", "eternal_starlight:book", "evilcraft:origins_of_darkness", "iceandfire:bestiary", "immersiveengineering:manual", "integrateddynamics:on_the_dynamics_of_integration", "merrymaking:merrymanual", "nautec:nautec_guide", "occultism:dictionary_of_spirits", "paganbless:pagan_guide", "powah:book", "rootsclassic:runic_tablet", "securitycraft:sc_manual", "tconstruct:fantastic_foundry", "tconstruct:materials_and_you", "tconstruct:mighty_smelting", "tconstruct:puny_smelting", "tconstruct:tinkers_gadgetry", "theoneprobe:probenote", "fargostalismans:guide_book", "solonion:food_book", "rftoolsbase:manual", "modern_industrialization:guidebook"), () -> "", Validator::isStringResource);
        ALIASES = BUILDER.comment("Mod aliases").defineListAllowEmpty(List.of("aliases"), () -> List.of("mythicbotany=botania", "integratedtunnels=integrateddynamics", "integratedterminals=integrateddynamics", "integratedcrafting=integrateddynamics", "rftoolsbuilder=rftoolsbase", "rftoolscontrol=rftoolsbase", "rftoolsdim=rftoolsbase", "rftoolspower=rftoolsbase", "rftoolsstorage=rftoolsbase", "rftoolsutility=rftoolsbase", "rftoolspower=rftoolsbase", "deepresonance=rftoolsbase", "xnet=rftoolsbase", "mysticalaggraditions=mysticalagriculture"), () -> "", Validator::isStringAlias);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public static class Validator {
        public static boolean isString(Object object) {
            return object instanceof String;
        }

        public static boolean isStringResource(Object object) {
            String pattern = "^.+:.+$";
            return Validator.isString(object) && ((String)object).matches(pattern);
        }

        public static boolean isStringAlias(Object object) {
            String pattern = "^.+=.+$";
            return Validator.isString(object) && ((String)object).matches(pattern);
        }
    }
}

