/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic.util;

import dev.muon.irons_apothic.IronsApothic;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.network.casting.OnCastStartedPacket;
import io.redspace.ironsspellbooks.network.casting.OnClientCastPacket;
import io.redspace.ironsspellbooks.network.casting.SyncTargetingDataPacket;
import io.redspace.ironsspellbooks.network.casting.UpdateCastingStatePacket;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class SpellCastUtil {
    public static void castSpell(LivingEntity caster, AbstractSpell spell, int spellLevel, LivingEntity target) {
        if (caster.level().isClientSide()) {
            return;
        }
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)caster);
        if (magicData.isCasting()) {
            IronsApothic.LOGGER.debug("SpellTriggerAffix: Entity is still casting {}, forcing spell completion", (Object)magicData.getCastingSpellId());
            AbstractSpell oldSpell = magicData.getCastingSpell().getSpell();
            oldSpell.onCast(caster.level(), magicData.getCastingSpellLevel(), caster, magicData.getCastSource(), magicData);
            oldSpell.onServerCastComplete(caster.level(), magicData.getCastingSpellLevel(), caster, magicData, false);
            magicData.resetCastingState();
            magicData = MagicData.getPlayerMagicData((LivingEntity)caster);
        }
        IronsApothic.LOGGER.debug("SpellTriggerAffix: Merging target data, target: {}", (Object)target.getName().getString());
        SpellCastUtil.updateTargetData(caster, (Entity)target, magicData, spell, x -> true);
        if (caster instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)caster;
            IronsApothic.LOGGER.debug("Casting SPELL FOR SERVERPLAYA");
            SpellCastUtil.castSpellForPlayer(spell, spellLevel, serverPlayer, magicData);
        } else if (caster instanceof IMagicEntity) {
            IMagicEntity magicEntity = (IMagicEntity)caster;
            magicEntity.initiateCastSpell(spell, spellLevel);
        } else if (caster instanceof LivingEntity && spell.checkPreCastConditions(caster.level(), spellLevel, caster, magicData)) {
            spell.onCast(caster.level(), spellLevel, caster, CastSource.COMMAND, magicData);
            spell.onServerCastComplete(caster.level(), spellLevel, caster, magicData, false);
        }
    }

    private static void castSpellForPlayer(AbstractSpell spell, int spellLevel, ServerPlayer serverPlayer, MagicData magicData) {
        if (magicData.isCasting()) {
            IronsApothic.LOGGER.warn("Attempted to trigger affix-cast while player was already casting");
            return;
        }
        if (serverPlayer.isUsingItem()) {
            serverPlayer.stopUsingItem();
        }
        int effectiveCastTime = 0;
        if (spell.getCastType() == CastType.CONTINUOUS) {
            effectiveCastTime = spell.getEffectiveCastTime(spellLevel, (LivingEntity)serverPlayer);
        }
        magicData.initiateCast(spell, spellLevel, effectiveCastTime, CastSource.COMMAND, "command");
        magicData.setPlayerCastingItem(ItemStack.EMPTY);
        spell.onServerPreCast(serverPlayer.level(), spellLevel, (LivingEntity)serverPlayer, magicData);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new UpdateCastingStatePacket(spell.getSpellId(), spellLevel, effectiveCastTime, CastSource.COMMAND, "command"), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverPlayer, (CustomPacketPayload)new OnCastStartedPacket(serverPlayer.getUUID(), spell.getSpellId(), spellLevel), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ICastData iCastData = magicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData) {
            TargetEntityCastData targetingData = (TargetEntityCastData)iCastData;
            LivingEntity target = targetingData.getTarget((ServerLevel)serverPlayer.level());
            if (target != null) {
                IronsApothic.LOGGER.debug("Casting Spell {} with target {}", (Object)magicData.getCastingSpellId(), (Object)target.getName().getString());
            }
        } else {
            IronsApothic.LOGGER.warn("Tried to merge Targeting Data but was overridden. Current cast data for spell {}: {}", (Object)magicData.getCastingSpellId(), (Object)magicData.getAdditionalCastData());
        }
        if (effectiveCastTime == 0) {
            spell.onCast(serverPlayer.level(), spellLevel, (LivingEntity)serverPlayer, CastSource.COMMAND, magicData);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OnClientCastPacket(spell.getSpellId(), spellLevel, CastSource.COMMAND, magicData.getAdditionalCastData()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void updateTargetData(LivingEntity caster, Entity entityHit, MagicData playerMagicData, AbstractSpell spell, Predicate<LivingEntity> filter) {
        LivingEntity livingParent;
        PartEntity partEntity;
        Entity entity;
        LivingEntity livingEntity;
        LivingEntity livingTarget = null;
        if (entityHit instanceof LivingEntity && filter.test(livingEntity = (LivingEntity)entityHit)) {
            livingTarget = livingEntity;
        } else if (entityHit instanceof PartEntity && (entity = (partEntity = (PartEntity)entityHit).getParent()) instanceof LivingEntity && filter.test(livingParent = (LivingEntity)entity)) {
            livingTarget = livingParent;
        }
        if (livingTarget != null) {
            ServerPlayer serverPlayer;
            playerMagicData.setAdditionalCastData((ICastData)new TargetEntityCastData(livingTarget));
            if (caster instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)caster;
                if (spell.getCastType() != CastType.INSTANT) {
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncTargetingDataPacket(livingTarget, spell), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"ui.irons_spellbooks.spell_target_success", (Object[])new Object[]{livingTarget.getDisplayName().getString(), spell.getDisplayName((Player)serverPlayer)}).withStyle(ChatFormatting.GREEN)));
            }
            if (livingTarget instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)livingTarget;
                Utils.sendTargetedNotification((ServerPlayer)serverPlayer, (LivingEntity)caster, (AbstractSpell)spell);
            }
        } else if (caster instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)caster;
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"ui.irons_spellbooks.cast_error_target").withStyle(ChatFormatting.RED)));
        }
    }
}

