/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.irons_apothic.affix.SchoolFilteredAffix;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class SpellEffectAffix
extends SchoolFilteredAffix {
    public static final Codec<SpellEffectAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(Affix.affixDef(), (App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("mob_effect").forGetter(a -> a.effect), (App)SpellTarget.CODEC.fieldOf("target").forGetter(a -> a.target), (App)LootRarity.mapCodec(EffectData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types), (App)Codec.BOOL.optionalFieldOf("stack_on_reapply", (Object)false).forGetter(a -> a.stackOnReapply), (App)Codec.intRange((int)1, (int)255).optionalFieldOf("stacking_limit", (Object)255).forGetter(a -> a.stackingLimit), (App)ResourceLocation.CODEC.optionalFieldOf("school").forGetter(a -> a.schoolIds.filter(list -> list.size() == 1).map(list -> (ResourceLocation)list.get(0))), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("schools").forGetter(a -> a.schoolIds)).apply((Applicative)inst, (def, effect, target, values, types, stackOnReapply, stackingLimit, singleSchool, schoolsArray) -> {
        Optional<List<ResourceLocation>> schoolIds = schoolsArray.isPresent() ? schoolsArray : singleSchool.map(List::of);
        return new SpellEffectAffix((AffixDefinition)def, (Holder<MobEffect>)effect, (SpellTarget)((Object)((Object)target)), (Map<LootRarity, EffectData>)values, (Set<LootCategory>)types, (boolean)stackOnReapply, (int)stackingLimit, schoolIds);
    }));
    protected final Holder<MobEffect> effect;
    protected final SpellTarget target;
    protected final Map<LootRarity, EffectData> values;
    protected final Set<LootCategory> types;
    protected final boolean stackOnReapply;
    protected final int stackingLimit;
    protected final Optional<List<ResourceLocation>> schoolIds;
    protected final Optional<Set<SchoolType>> schools;

    public void applyEffectInternal(LivingEntity target, AffixInstance inst) {
        EffectData data = this.values.get(inst.rarity().get());
        if (data == null || target.level().isClientSide()) {
            return;
        }
        int cooldown = data.cooldown();
        if (cooldown != 0 && Affix.isOnCooldown((ResourceLocation)this.id(), (int)cooldown, (LivingEntity)target)) {
            return;
        }
        MobEffectInstance currentInst = target.getEffect(this.effect);
        MobEffectInstance newInst = data.build(this.effect, inst.level());
        if (this.stackOnReapply && currentInst != null) {
            int newAmp = Math.min(this.stackingLimit - 1, currentInst.getAmplifier() + newInst.getAmplifier() + 1);
            int newDur = Math.max(currentInst.getDuration(), newInst.getDuration());
            MobEffectInstance combinedInst = new MobEffectInstance(this.effect, newDur, newAmp, currentInst.isAmbient(), currentInst.isVisible(), currentInst.isVisible());
            target.removeEffect(this.effect);
            target.addEffect(combinedInst);
        } else {
            target.addEffect(newInst);
        }
        if (cooldown != 0) {
            Affix.startCooldown((ResourceLocation)this.id(), (LivingEntity)target);
        }
    }

    public SpellEffectAffix(AffixDefinition definition, Holder<MobEffect> effect, SpellTarget target, Map<LootRarity, EffectData> values, Set<LootCategory> types, boolean stackOnReapply, int stackingLimit, Optional<List<ResourceLocation>> schoolIds) {
        super(definition);
        this.effect = effect;
        this.target = target;
        this.values = values;
        this.types = types;
        this.stackOnReapply = stackOnReapply;
        this.stackingLimit = stackingLimit;
        this.schoolIds = schoolIds;
        this.schools = schoolIds.map(ids -> {
            HashSet<SchoolType> schoolSet = new HashSet<SchoolType>();
            for (ResourceLocation id : ids) {
                SchoolType school = (SchoolType)SchoolRegistry.REGISTRY.get(id);
                if (school != null) {
                    schoolSet.add(school);
                    continue;
                }
                Apotheosis.LOGGER.warn("Unknown school ID {} provided for SpellEffectAffix, ignoring.", (Object)id);
            }
            return schoolSet;
        });
    }

    private static Component toComponent(MobEffectInstance inst, float tickRate) {
        MutableComponent mutablecomponent = Component.translatable((String)inst.getDescriptionId());
        Holder mobeffect = inst.getEffect();
        if (inst.getAmplifier() > 0) {
            mutablecomponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.translatable((String)("potion.potency." + inst.getAmplifier()))});
        }
        if (inst.getDuration() > 20) {
            mutablecomponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.formatDuration((MobEffectInstance)inst, (float)1.0f, (float)tickRate)});
        }
        return mutablecomponent.withStyle(((MobEffect)mobeffect.value()).getCategory().getTooltipFormatting());
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        if (!this.types.isEmpty() && !this.types.contains(cat) || !this.values.containsKey(rarity)) {
            return false;
        }
        return SpellEffectAffix.matchesSchools(stack, this.schools);
    }

    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        EffectData data = this.values.get(inst.rarity().get());
        if (data == null) {
            return Component.empty();
        }
        MobEffectInstance effectInst = data.build(this.effect, inst.level());
        MutableComponent comp = Component.translatable((String)("affix.irons_apothic.target." + this.target.name().toLowerCase()), (Object[])new Object[]{SpellEffectAffix.toComponent(effectInst, ctx.tickRate())});
        int cooldown = data.cooldown();
        if (cooldown != 0) {
            MutableComponent cd = Component.translatable((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.formatTickDuration((int)cooldown, (float)ctx.tickRate())});
            comp = comp.append(" ").append((Component)cd);
        }
        if (this.stackOnReapply) {
            comp = comp.append(" ").append((Component)Component.translatable((String)"affix.apotheosis.stacking"));
        }
        return comp;
    }

    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        int cooldown;
        MutableComponent maxComp;
        MutableComponent minComp;
        LootRarity rarity = (LootRarity)inst.rarity().get();
        EffectData data = this.values.get(rarity);
        if (data == null) {
            return Component.empty();
        }
        MobEffectInstance currentEffect = data.build(this.effect, inst.level());
        MutableComponent comp = Component.translatable((String)("affix.irons_apothic.target." + this.target.name().toLowerCase()), (Object[])new Object[]{SpellEffectAffix.toComponent(currentEffect, ctx.tickRate())});
        MobEffectInstance min = data.build(this.effect, 0.0f);
        MobEffectInstance max = data.build(this.effect, 1.0f);
        if (min.getAmplifier() != max.getAmplifier()) {
            minComp = min.getAmplifier() == 0 ? Component.literal((String)"I") : Component.translatable((String)("potion.potency." + min.getAmplifier()));
            maxComp = Component.translatable((String)("potion.potency." + max.getAmplifier()));
            comp.append((Component)Affix.valueBounds((Component)minComp, (Component)maxComp));
        }
        if (!((MobEffect)this.effect.value()).isInstantenous() && min.getDuration() != max.getDuration()) {
            minComp = MobEffectUtil.formatDuration((MobEffectInstance)min, (float)1.0f, (float)ctx.tickRate());
            maxComp = MobEffectUtil.formatDuration((MobEffectInstance)max, (float)1.0f, (float)ctx.tickRate());
            comp.append((Component)Affix.valueBounds((Component)minComp, (Component)maxComp));
        }
        if ((cooldown = data.cooldown()) != 0) {
            MutableComponent cd = Component.translatable((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.formatTickDuration((int)cooldown, (float)ctx.tickRate())});
            comp = comp.append(" ").append((Component)cd);
        }
        if (this.stackOnReapply) {
            comp = comp.append(" ").append((Component)Component.translatable((String)"affix.apotheosis.stacking"));
        }
        return comp;
    }

    public record EffectData(StepFunction duration, StepFunction amplifier, int cooldown) {
        private static Codec<EffectData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.fieldOf("duration").forGetter(EffectData::duration), (App)StepFunction.CODEC.fieldOf("amplifier").forGetter(EffectData::amplifier), (App)Codec.INT.optionalFieldOf("cooldown", (Object)0).forGetter(EffectData::cooldown)).apply((Applicative)inst, EffectData::new));

        public MobEffectInstance build(Holder<MobEffect> effect, float level) {
            float clampedLevel = Math.max(0.0f, level);
            return new MobEffectInstance(effect, this.duration.getInt(clampedLevel), this.amplifier.getInt(clampedLevel));
        }
    }

    public static enum SpellTarget {
        SPELL_DAMAGE_SELF,
        SPELL_DAMAGE_TARGET,
        SPELL_HEAL_SELF,
        SPELL_HEAL_TARGET;

        public static final Codec<SpellTarget> CODEC;

        static {
            CODEC = PlaceboCodecs.enumCodec(SpellTarget.class);
        }
    }
}

