/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic.affix;

import com.google.common.collect.Multimap;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import io.redspace.ironsspellbooks.api.item.UpgradeData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.item.armor.UpgradeOrbType;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class SchoolFilteredAffix
extends Affix {
    private static final String SPELL_POWER_SUFFIX = "_spell_power";

    protected SchoolFilteredAffix(AffixDefinition definition) {
        super(definition);
    }

    protected static boolean matchesSchools(ItemStack stack, Optional<Set<SchoolType>> schools) {
        Item entry2;
        if (schools.isEmpty()) {
            return true;
        }
        Set<SchoolType> allowedSchools = schools.get();
        HashSet<SchoolType> gearSchools = new HashSet<SchoolType>();
        boolean hasGenericSpellPower = false;
        ItemAttributeModifiers componentModifiers = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        for (Item entry2 : componentModifiers.modifiers()) {
            Holder attributeHolder = entry2.attribute();
            if (!attributeHolder.isBound()) continue;
            Attribute attr = (Attribute)attributeHolder.value();
            SchoolType school = SchoolFilteredAffix.getSchoolFromAttribute(attr);
            if (school != null) {
                gearSchools.add(school);
                continue;
            }
            if (!SchoolFilteredAffix.isGenericSpellPower(attr)) continue;
            hasGenericSpellPower = true;
        }
        entry2 = stack.getItem();
        if (entry2 instanceof ICurioItem) {
            ICurioItem curio = (ICurioItem)entry2;
            Map slotTypes = CuriosApi.getItemStackSlots((ItemStack)stack, (boolean)false);
            for (String slotId : slotTypes.keySet()) {
                SlotContext context = new SlotContext(slotId, null, -1, false, true);
                ResourceLocation modifierId = ResourceLocation.fromNamespaceAndPath((String)"irons_apothic", (String)"school_check");
                Multimap attributes = curio.getAttributeModifiers(context, modifierId, stack);
                for (Holder attributeHolder : attributes.keySet()) {
                    if (!attributeHolder.isBound()) continue;
                    Attribute attr = (Attribute)attributeHolder.value();
                    SchoolType school = SchoolFilteredAffix.getSchoolFromAttribute(attr);
                    if (school != null) {
                        gearSchools.add(school);
                        continue;
                    }
                    if (!SchoolFilteredAffix.isGenericSpellPower(attr)) continue;
                    hasGenericSpellPower = true;
                }
            }
        }
        UpgradeData upgradeData = UpgradeData.getUpgradeData((ItemStack)stack);
        for (Holder upgradeHolder : upgradeData.upgrades().keySet()) {
            UpgradeOrbType upgradeOrb;
            Holder attributeHolder;
            if (!upgradeHolder.isBound() || !(attributeHolder = (upgradeOrb = (UpgradeOrbType)upgradeHolder.value()).attribute()).isBound()) continue;
            Attribute attr = (Attribute)attributeHolder.value();
            SchoolType school = SchoolFilteredAffix.getSchoolFromAttribute(attr);
            if (school != null) {
                gearSchools.add(school);
                continue;
            }
            if (!SchoolFilteredAffix.isGenericSpellPower(attr)) continue;
            hasGenericSpellPower = true;
        }
        if (allowedSchools.isEmpty()) {
            return hasGenericSpellPower || gearSchools.isEmpty();
        }
        for (SchoolType gearSchool : gearSchools) {
            if (!allowedSchools.contains(gearSchool)) continue;
            return true;
        }
        return false;
    }

    private static boolean isGenericSpellPower(Attribute attribute) {
        ResourceLocation attrId = BuiltInRegistries.ATTRIBUTE.getKey((Object)attribute);
        return attrId != null && attrId.getPath().equals("spell_power");
    }

    private static SchoolType getSchoolFromAttribute(Attribute attribute) {
        ResourceLocation attrId = BuiltInRegistries.ATTRIBUTE.getKey((Object)attribute);
        if (attrId == null) {
            return null;
        }
        String path = attrId.getPath();
        if (path.endsWith(SPELL_POWER_SUFFIX) && path.length() > SPELL_POWER_SUFFIX.length()) {
            String schoolName = path.substring(0, path.length() - SPELL_POWER_SUFFIX.length());
            ResourceLocation schoolResource = ResourceLocation.fromNamespaceAndPath((String)attrId.getNamespace(), (String)schoolName);
            return (SchoolType)SchoolRegistry.REGISTRY.get(schoolResource);
        }
        return null;
    }
}

