/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironenderchests.setup;

import io.redspace.ironenderchests.IronEnderChests;
import io.redspace.ironenderchests.blocks.AbstractEnderChestBlockEntity;
import io.redspace.ironenderchests.client.TieredEnderChestItemStackRenderer;
import io.redspace.ironenderchests.client.TieredEnderChestRenderer;
import io.redspace.ironenderchests.items.EnderChestBlockItem;
import io.redspace.ironenderchests.registries.BlockRegistry;
import io.redspace.ironenderchests.registries.ItemRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="iron_ender_chests", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        IronEnderChests.LOGGER.debug("ClientSetup.registerRenderers");
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.NETHERITE_ENDER_CHEST_ENTITY.get(), TieredEnderChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.DIAMOND_ENDER_CHEST_ENTITY.get(), TieredEnderChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.IRON_ENDER_CHEST_ENTITY.get(), TieredEnderChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.COPPER_ENDER_CHEST_ENTITY.get(), TieredEnderChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.GOLD_ENDER_CHEST_ENTITY.get(), TieredEnderChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.LAPIS_ENDER_CHEST_ENTITY.get(), TieredEnderChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.REDSTONE_ENDER_CHEST_ENTITY.get(), TieredEnderChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.EMERALD_ENDER_CHEST_ENTITY.get(), TieredEnderChestRenderer::new);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        for (Holder item : ItemRegistry.ITEMS.getEntries()) {
            Object object = item.value();
            if (!(object instanceof EnderChestBlockItem)) continue;
            final EnderChestBlockItem enderChestBlockItem = (EnderChestBlockItem)((Object)object);
            event.registerItem(new IClientItemExtensions(){

                @NotNull
                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return new TieredEnderChestItemStackRenderer<AbstractEnderChestBlockEntity>(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels(), enderChestBlockItem::getEntityToRender);
                }
            }, new Item[]{enderChestBlockItem});
        }
    }
}

