/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironenderchests.items;

import io.redspace.ironenderchests.blocks.AbstractEnderChestBlockEntity;
import io.redspace.ironenderchests.blocks.copper_ender_chest.CopperEnderChestEntity;
import io.redspace.ironenderchests.blocks.diamond_ender_chest.DiamondEnderChestEntity;
import io.redspace.ironenderchests.blocks.emerald_ender_chest.EmeraldEnderChestEntity;
import io.redspace.ironenderchests.blocks.gold_ender_chest.GoldEnderChestEntity;
import io.redspace.ironenderchests.blocks.iron_ender_chest.IronEnderChestEntity;
import io.redspace.ironenderchests.blocks.lapis_ender_chest.LapisEnderChestEntity;
import io.redspace.ironenderchests.blocks.netherite_ender_chest.NetheriteEnderChestEntity;
import io.redspace.ironenderchests.blocks.redstone_ender_chest.RedstoneEnderChestEntity;
import io.redspace.ironenderchests.registries.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;

public class EnderChestBlockItem
extends BlockItem {
    private final Block block;
    final List<Component> description;

    public EnderChestBlockItem(Block pBlock, Item.Properties pProperties, String ... description) {
        super(pBlock, pProperties);
        this.block = pBlock;
        this.description = new ArrayList<Component>();
        for (String str : description) {
            this.description.add((Component)Component.translatable((String)str).withStyle(ChatFormatting.GRAY));
        }
    }

    public AbstractEnderChestBlockEntity getEntityToRender() {
        return switch (this.block.getDescriptionId()) {
            case "block.iron_ender_chests.diamond_ender_chest" -> new DiamondEnderChestEntity(BlockPos.ZERO, ((Block)BlockRegistry.DIAMOND_ENDER_CHEST.get()).defaultBlockState());
            case "block.iron_ender_chests.netherite_ender_chest" -> new NetheriteEnderChestEntity(BlockPos.ZERO, ((Block)BlockRegistry.NETHERITE_ENDER_CHEST.get()).defaultBlockState());
            case "block.iron_ender_chests.copper_ender_chest" -> new CopperEnderChestEntity(BlockPos.ZERO, ((Block)BlockRegistry.COPPER_ENDER_CHEST.get()).defaultBlockState());
            case "block.iron_ender_chests.gold_ender_chest" -> new GoldEnderChestEntity(BlockPos.ZERO, ((Block)BlockRegistry.GOLD_ENDER_CHEST.get()).defaultBlockState());
            case "block.iron_ender_chests.lapis_ender_chest" -> new LapisEnderChestEntity(BlockPos.ZERO, ((Block)BlockRegistry.LAPIS_ENDER_CHEST.get()).defaultBlockState());
            case "block.iron_ender_chests.redstone_ender_chest" -> new RedstoneEnderChestEntity(BlockPos.ZERO, ((Block)BlockRegistry.REDSTONE_ENDER_CHEST.get()).defaultBlockState());
            case "block.iron_ender_chests.emerald_ender_chest" -> new EmeraldEnderChestEntity(BlockPos.ZERO, ((Block)BlockRegistry.EMERALD_ENDER_CHEST.get()).defaultBlockState());
            default -> new IronEnderChestEntity(BlockPos.ZERO, ((Block)BlockRegistry.IRON_ENDER_CHEST.get()).defaultBlockState());
        };
    }

    public void appendHoverText(ItemStack p_40572_, Item.TooltipContext p_339655_, List<Component> p_40574_, TooltipFlag p_40575_) {
        super.appendHoverText(p_40572_, p_339655_, p_40574_, p_40575_);
        p_40574_.addAll(this.description);
    }
}

