/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironenderchests.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractEnderChestBlockEntity
extends EnderChestBlockEntity {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level p_155531_, BlockPos p_155532_, BlockState p_155533_) {
            p_155531_.playSound((Player)null, (double)p_155532_.getX() + 0.5, (double)p_155532_.getY() + 0.5, (double)p_155532_.getZ() + 0.5, SoundEvents.ENDER_CHEST_OPEN, SoundSource.BLOCKS, 0.5f, p_155531_.random.nextFloat() * 0.1f + 0.9f);
        }

        protected void onClose(Level p_155541_, BlockPos p_155542_, BlockState p_155543_) {
            p_155541_.playSound((Player)null, (double)p_155542_.getX() + 0.5, (double)p_155542_.getY() + 0.5, (double)p_155542_.getZ() + 0.5, SoundEvents.ENDER_CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, p_155541_.random.nextFloat() * 0.1f + 0.9f);
        }

        protected void openerCountChanged(Level p_155535_, BlockPos p_155536_, BlockState p_155537_, int p_155538_, int p_155539_) {
            p_155535_.blockEvent(AbstractEnderChestBlockEntity.this.worldPosition, AbstractEnderChestBlockEntity.this.getBlock(), 1, p_155539_);
        }

        protected boolean isOwnContainer(Player p_155529_) {
            return p_155529_.getEnderChestInventory().isActiveChest((EnderChestBlockEntity)AbstractEnderChestBlockEntity.this);
        }
    };

    protected abstract Block getBlock();

    @Deprecated
    protected abstract BlockEntityType<?> getBlockEntityType();

    public AbstractEnderChestBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState);
        this.type = this.getBlockEntityType();
    }

    public BlockEntityType<?> getType() {
        return this.getBlockEntityType();
    }

    public void startOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.incrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.decrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }
}

