/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironenderchests.blocks;

import io.redspace.ironenderchests.IExtendedPlayer;
import io.redspace.ironenderchests.blocks.AbstractEnderChestBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEnderChest<E extends AbstractEnderChestBlockEntity>
extends EnderChestBlock {
    protected final DeferredHolder<BlockEntityType<E>, BlockEntityType<E>> entityType;
    private final Component CONTAINER_TITLE;

    public AbstractEnderChest(DeferredHolder<BlockEntityType<E>, BlockEntityType<E>> entityType, String titleMaterial) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ENDER_CHEST));
        this.entityType = entityType;
        this.CONTAINER_TITLE = Component.translatable((String)("block.iron_ender_chests." + titleMaterial + "_ender_chest"));
        this.registerDefaultState((BlockState)this.stateDefinition.any());
    }

    public abstract BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.isClientSide ? AbstractEnderChest.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)this.entityType.get()), EnderChestBlockEntity::lidAnimateTick) : null;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, Level level, @NotNull BlockPos pos, Player player, BlockHitResult blockHitResult) {
        PlayerEnderChestContainer enderChest = player.getEnderChestInventory();
        PlayerEnderChestContainer extendedEnderChest = ((IExtendedPlayer)player).getExtendedEnderChest();
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof EnderChestBlockEntity) {
            BlockPos blockpos = pos.above();
            if (level.getBlockState(blockpos).isRedstoneConductor((BlockGetter)level, blockpos)) {
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            CompoundContainer container = new CompoundContainer((Container)enderChest, (Container)extendedEnderChest);
            EnderChestBlockEntity enderchestblockentity = (EnderChestBlockEntity)blockentity;
            enderChest.setActiveChest(enderchestblockentity);
            extendedEnderChest.setActiveChest(enderchestblockentity);
            player.openMenu((MenuProvider)new SimpleMenuProvider((arg_0, arg_1, arg_2) -> this.lambda$useWithoutItem$0((Container)container, arg_0, arg_1, arg_2), this.CONTAINER_TITLE));
            player.awardStat(Stats.OPEN_ENDERCHEST);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return super.getRenderShape(pState);
    }

    protected abstract AbstractContainerMenu getMenuProvider(int var1, Inventory var2, Container var3);

    private /* synthetic */ AbstractContainerMenu lambda$useWithoutItem$0(Container container, int i, Inventory inventory, Player player1) {
        return this.getMenuProvider(i, inventory, container);
    }
}

