/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.util;

import java.util.HashSet;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class AttributeUtils {
    public static void mergeAttributes(DataComponentPatch.Builder builder, Item item, ItemAttributeModifiers newModifiers) {
        ItemAttributeModifiers existingModifiers = (ItemAttributeModifiers)item.components().getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        HashSet<Holder> attributesOverwritten = new HashSet<Holder>();
        for (ItemAttributeModifiers.Entry entry : newModifiers.modifiers()) {
            attributesOverwritten.add(entry.attribute());
        }
        ItemAttributeModifiers.Builder combinedBuilder = ItemAttributeModifiers.builder();
        for (ItemAttributeModifiers.Entry entry : existingModifiers.modifiers()) {
            if (attributesOverwritten.contains(entry.attribute())) continue;
            combinedBuilder.add(entry.attribute(), entry.modifier(), entry.slot());
        }
        for (ItemAttributeModifiers.Entry entry : newModifiers.modifiers()) {
            combinedBuilder.add(entry.attribute(), entry.modifier(), entry.slot());
        }
        builder.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)combinedBuilder.build());
    }
}

