/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.items;

import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.init.ModKeybind;
import com.github.L_Ender.cataclysm.items.KeybindUsingArmor;
import com.github.L_Ender.cataclysm.message.MessageArmorKey;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class Cursium_Armor
extends ArmorItem
implements KeybindUsingArmor {
    public Cursium_Armor(Holder<ArmorMaterial> material, ArmorItem.Type slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public boolean isValidRepairItem(ItemStack p_41134_, ItemStack p_41135_) {
        return p_41135_.is((Item)ModItems.CURSIUM_INGOT.get());
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        block9: {
            block8: {
                super.inventoryTick(stack, level, entity, slotId, isSelected);
                if (!(entity instanceof Player)) break block8;
                player = (Player)entity;
                if (level.isClientSide) break block9;
            }
            return;
        }
        if (this.type == ArmorItem.Type.HELMET && player.getItemBySlot(EquipmentSlot.HEAD) == stack) {
            if (ModKeybind.HELMET_KEY_ABILITY.consumeClick()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MessageArmorKey(EquipmentSlot.HEAD.ordinal(), player.getId(), 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.onKeyPacket(player, stack, 5);
            }
        } else if (this.type == ArmorItem.Type.BOOTS && player.getItemBySlot(EquipmentSlot.FEET) == stack && ModKeybind.BOOTS_KEY_ABILITY.consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageArmorKey(EquipmentSlot.FEET.ordinal(), player.getId(), 7), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.onKeyPacket(player, stack, 7);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
        if (this.type == ArmorItem.Type.HELMET) {
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_helmet.desc").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_helmet.desc2", (Object[])new Object[]{ModKeybind.HELMET_KEY_ABILITY.getTranslatedKeyMessage()}).withStyle(ChatFormatting.DARK_GREEN));
        } else if (this.type == ArmorItem.Type.CHESTPLATE) {
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_chestplate.desc").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_chestplate.desc2").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_chestplate.desc3").withStyle(ChatFormatting.DARK_GREEN));
        } else if (this.type == ArmorItem.Type.LEGGINGS) {
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_leggings.desc").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_leggings.desc2").withStyle(ChatFormatting.DARK_GREEN));
        } else if (this.type == ArmorItem.Type.BOOTS) {
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_boots.desc").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_boots.desc2", (Object[])new Object[]{ModKeybind.BOOTS_KEY_ABILITY.getTranslatedKeyMessage()}).withStyle(ChatFormatting.DARK_GREEN));
        }
    }

    @Override
    public void onKeyPacket(Player player, ItemStack itemStack, int type) {
        if (player == null) {
            return;
        }
        if (type == 5 && !player.getCooldowns().isOnCooldown((Item)ModItems.CURSIUM_HELMET.get())) {
            boolean targetFound = false;
            List list = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(24.0));
            for (Entity entity : list) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                if (entity == player) continue;
                targetFound = true;
                living.addEffect(new MobEffectInstance(MobEffects.GLOWING, 160));
            }
            if (targetFound) {
                player.getCooldowns().addCooldown((Item)ModItems.CURSIUM_HELMET.get(), 200);
            }
        }
        if (type == 7 && player.onGround() && !player.getCooldowns().isOnCooldown((Item)ModItems.CURSIUM_BOOTS.get())) {
            float speed = -1.8f;
            float dodgeYaw = (float)Math.toRadians(player.getYRot() + 90.0f);
            double velX = (double)speed * Math.cos(dodgeYaw);
            double velZ = (double)speed * Math.sin(dodgeYaw);
            Vec3 currentVel = player.getDeltaMovement();
            player.setDeltaMovement(currentVel.x + velX, 0.4, currentVel.z + velZ);
            player.hurtMarked = true;
            player.getCooldowns().addCooldown((Item)ModItems.CURSIUM_BOOTS.get(), 200);
        }
    }

    public ResourceLocation getArmorTexture(@Nonnull ItemStack stack, @Nonnull Entity entity, @Nonnull EquipmentSlot slot, @Nonnull ArmorMaterial.Layer layer, boolean isInnerModel) {
        return ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)("textures/armor/cursium_armor" + (slot == EquipmentSlot.LEGS ? "_legs.png" : ".png")));
    }
}

