/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm;

import com.github.L_Ender.cataclysm.ServerProxy;
import com.github.L_Ender.cataclysm.client.sound.MeatShredderSound;
import com.github.L_Ender.cataclysm.client.sound.SandstormSound;
import com.github.L_Ender.cataclysm.entity.effect.Sandstorm_Entity;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ClientProxy
extends ServerProxy {
    public static final Int2ObjectMap<AbstractTickableSoundInstance> ENTITY_SOUND_INSTANCE_MAP = new Int2ObjectOpenHashMap();
    public static final Map<BlockEntity, AbstractTickableSoundInstance> BLOCK_ENTITY_SOUND_INSTANCE_MAP = new HashMap<BlockEntity, AbstractTickableSoundInstance>();
    public static List<UUID> blockedEntityRenders = new ArrayList<UUID>();
    public static Map<UUID, BossBarData> bossBarRenderTypes = new HashMap<UUID, BossBarData>();

    @Override
    public boolean isFirstPersonPlayer(Entity entity) {
        return entity.equals((Object)Minecraft.getInstance().cameraEntity) && Minecraft.getInstance().options.getCameraType().isFirstPerson();
    }

    @Override
    public void blockRenderingEntity(UUID id) {
        blockedEntityRenders.add(id);
    }

    @Override
    public void releaseRenderingEntity(UUID id) {
        blockedEntityRenders.remove(id);
    }

    @Override
    public Player getClientSidePlayer() {
        return Minecraft.getInstance().player;
    }

    @Override
    public float getPartialTicks() {
        return Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
    }

    @Override
    public void playWorldSound(@Nullable Object soundEmitter, byte type) {
        if (soundEmitter instanceof Entity) {
            Entity entity = (Entity)soundEmitter;
            if (!entity.level().isClientSide) {
                return;
            }
        }
        switch (type) {
            case 1: {
                MeatShredderSound sound;
                MeatShredderSound shredderSound;
                if (!(soundEmitter instanceof LivingEntity)) break;
                LivingEntity livingEntity = (LivingEntity)soundEmitter;
                AbstractTickableSoundInstance old = (AbstractTickableSoundInstance)ENTITY_SOUND_INSTANCE_MAP.get(livingEntity.getId());
                if (old == null || !(old instanceof MeatShredderSound) || !(shredderSound = (MeatShredderSound)old).isSameEntity(livingEntity)) {
                    sound = new MeatShredderSound(livingEntity);
                    ENTITY_SOUND_INSTANCE_MAP.put(livingEntity.getId(), (Object)sound);
                } else {
                    sound = (MeatShredderSound)old;
                }
                if (Minecraft.getInstance().getSoundManager().isActive((SoundInstance)sound) || !sound.canPlaySound()) break;
                Minecraft.getInstance().getSoundManager().queueTickingSound((TickableSoundInstance)sound);
                break;
            }
            case 2: {
                SandstormSound sound;
                SandstormSound sandstomSound;
                if (!(soundEmitter instanceof Sandstorm_Entity)) break;
                Sandstorm_Entity sandstom = (Sandstorm_Entity)((Object)soundEmitter);
                AbstractTickableSoundInstance old = (AbstractTickableSoundInstance)ENTITY_SOUND_INSTANCE_MAP.get(sandstom.getId());
                if (old == null || !(old instanceof SandstormSound) || !(sandstomSound = (SandstormSound)old).isSameEntity(sandstom)) {
                    sound = new SandstormSound(sandstom);
                    ENTITY_SOUND_INSTANCE_MAP.put(sandstom.getId(), (Object)sound);
                } else {
                    sound = (SandstormSound)old;
                }
                if (Minecraft.getInstance().getSoundManager().isActive((SoundInstance)sound) || !sound.canPlaySound()) break;
                Minecraft.getInstance().getSoundManager().queueTickingSound((TickableSoundInstance)sound);
            }
        }
    }

    @Override
    public void clearSoundCacheFor(Entity entity) {
        ENTITY_SOUND_INSTANCE_MAP.remove(entity.getId());
    }

    @Override
    public void clearSoundCacheFor(BlockEntity entity) {
        BLOCK_ENTITY_SOUND_INSTANCE_MAP.remove(entity);
    }

    public record BossBarData(int renderType, int remainLife) {
    }
}

