/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.utils;

import com.devdyna.synergy.init.Material;
import com.devdyna.synergy.utils.ColorUtil;
import com.devdyna.synergy.utils.StringUtil;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.Vec3;

public class LevelUtil {
    public static boolean isDimension(Level level, ResourceKey<Level> dim) {
        return level.dimension().equals(dim);
    }

    public static void SimplePlaceBlock(Level level, BlockPos pos, Block block) {
        level.setBlock(pos, block.defaultBlockState(), 32);
    }

    public static int ValidFaces(BlockPos pos, Level level, TagKey<Block> tag) {
        BlockPos[] dir = new BlockPos[]{pos.above(), pos.below(), pos.north(), pos.south(), pos.east(), pos.west()};
        int value = 0;
        for (BlockPos face : dir) {
            value += level.getBlockState(face).is(tag) ? 1 : 0;
        }
        return value;
    }

    public static List<Holder<Block>> BlockByTag(TagKey<Block> tag) {
        return BuiltInRegistries.BLOCK.getOrCreateTag(tag).stream().toList();
    }

    public static List<Holder<Block>> BlockByTagName(String tag) {
        return BuiltInRegistries.BLOCK.getOrCreateTag(Material.tagBlock(tag)).stream().toList();
    }

    public static List<Holder<Item>> ItemByTagName(String tag) {
        return BuiltInRegistries.ITEM.getOrCreateTag(Material.tagItem(tag)).stream().toList();
    }

    public static Block BlockByTag(TagKey<Block> tag, int index) {
        return (Block)LevelUtil.BlockByTag(tag).get(index).value();
    }

    public static List<Holder<Item>> ItemByTag(TagKey<Item> tag) {
        return BuiltInRegistries.ITEM.getOrCreateTag(tag).stream().toList();
    }

    public static List<Item> getItemByTag(TagKey<Item> tag) {
        return BuiltInRegistries.ITEM.getOrCreateTag(tag).stream().map(Holder::value).toList();
    }

    public static Item ItemByTag(TagKey<Item> tag, int index) {
        return (Item)LevelUtil.ItemByTag(tag).get(index).value();
    }

    public static int getSizeItemTag(TagKey<Item> tag) {
        return LevelUtil.ItemByTag(tag).size() - 1;
    }

    public static int getSizeBlockTag(TagKey<Block> tag) {
        return LevelUtil.BlockByTag(tag).size() - 1;
    }

    public static void popItemFromPos(Level level, BlockPos pos, ItemStack itemStack) {
        Block.popResource((Level)level, (BlockPos)pos, (ItemStack)itemStack);
    }

    public static void popItemFromPos(Level level, int x2, int y, int z, ItemStack itemStack) {
        LevelUtil.popItemFromPos(level, new BlockPos(x2, y, z), itemStack);
    }

    @Deprecated
    public static List<ItemStack> getItemStackFromLootTable(LevelAccessor level, String raw_ore_name, float luck) {
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)level);
        LootParams params = builder.create(LootContextParamSets.EMPTY);
        builder.withLuck(luck);
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)StringUtil.getModName(raw_ore_name), (String)("blocks/" + raw_ore_name.substring(raw_ore_name.lastIndexOf(46) + 1)))));
        return lootTable.getRandomItems(params);
    }

    @Deprecated
    public static List<ItemStack> getItemStackFromLootTable(LevelAccessor level, String raw_ore_name) {
        return LevelUtil.getItemStackFromLootTable(level, raw_ore_name, 1.0f);
    }

    @Deprecated
    public static List<ItemStack> getItemStackFromLootTable(LevelAccessor level, String raw_ore_name, Player player) {
        return LevelUtil.getItemStackFromLootTable(level, raw_ore_name, player.getLuck());
    }

    @Deprecated
    public static List<ItemStack> getItemStackFromLootTable(LevelAccessor level, BlockState state) {
        return LevelUtil.getItemStackFromLootTable(level, state.getBlock().getDescriptionId(), 1.0f);
    }

    public static List<ItemStack> getItemStackFromLootTable(ServerLevel level, String ModName, String resourcelocation) {
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ModName, (String)resourcelocation)));
        return lootTable.getRandomItems(new LootParams.Builder(level).create(LootContextParamSets.EMPTY));
    }

    public static int getRandomValue(int max, Level l) {
        if (max <= 0) {
            return 1;
        }
        return l.random.nextInt(max) + 1;
    }

    public static boolean chance(int value, Level l) {
        if (value == 0) {
            return false;
        }
        return LevelUtil.getRandomValue(100, l) <= value;
    }

    public static void addParticle(ParticleOptions type, ServerLevel level, BlockPos pos, boolean isRandom, int count) {
        level.sendParticles(type, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, count, isRandom ? level.random.nextDouble() / 2.5 : 0.0, isRandom ? level.random.nextDouble() / 2.5 : 0.0, isRandom ? level.random.nextDouble() / 2.5 : 0.0, isRandom ? level.random.nextDouble() * 0.025 : 0.0);
    }

    public static void addParticle(ParticleOptions type, ServerLevel level, BlockPos pos, boolean isRandom) {
        LevelUtil.addParticle(type, level, pos, isRandom, 1);
    }

    public static void addDustParticle(int red, int green, int blue, ServerLevel level, BlockPos pos, boolean isRandom, int count) {
        level.sendParticles((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)(red << 16 | green << 8 | blue)).toVector3f(), 1.0f), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, count, isRandom ? level.random.nextDouble() / 2.5 : 0.0, isRandom ? level.random.nextDouble() / 2.5 : 0.0, isRandom ? level.random.nextDouble() / 2.5 : 0.0, isRandom ? level.random.nextDouble() * 0.025 : 0.0);
    }

    public static void addDustParticle(int rgbColor, ServerLevel level, BlockPos pos, boolean isRandom, int count) {
        level.sendParticles((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)rgbColor).toVector3f(), 1.0f), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, count, isRandom ? level.random.nextDouble() / 2.5 : 0.0, isRandom ? level.random.nextDouble() / 2.5 : 0.0, isRandom ? level.random.nextDouble() / 2.5 : 0.0, isRandom ? level.random.nextDouble() * 0.025 : 0.0);
    }

    public static void addDustParticle(ServerLevel level, BlockPos pos, boolean isRandom) {
        Random random = new Random();
        LevelUtil.addDustParticle(random.nextInt(256), random.nextInt(256), random.nextInt(256), level, pos, isRandom, 1);
    }

    public static void addRainbowDustParticle(ServerLevel level, BlockPos pos, boolean isRandom) {
        LevelUtil.addDustParticle(ColorUtil.rgbColor((Level)level), level, pos, isRandom, 1);
    }

    public static void addRainbowDustParticle(ServerLevel level, BlockPos pos, boolean isRandom, int count) {
        LevelUtil.addDustParticle(ColorUtil.rgbColor((Level)level), level, pos, isRandom, count);
    }

    public static void addRainbowDustParticle(int delay, ServerLevel level, BlockPos pos, boolean isRandom, int count) {
        LevelUtil.addDustParticle(ColorUtil.rgbColor((Level)level, delay), level, pos, isRandom, count);
    }

    public static int predicateNeighborMatch(Level level, BlockPos pos, Predicate<Block> predicate) {
        int counter = 0;
        for (Direction dir : Direction.values()) {
            Block block = level.getBlockState(pos.relative(dir)).getBlock();
            if (!predicate.test(block)) continue;
            ++counter;
        }
        return counter;
    }
}

