/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.utils;

import com.devdyna.synergy.datagen.server.DataGlobalLootModifier;
import com.devdyna.synergy.utils.ArrayUtils;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.loot.AddTableLootModifier;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DataGenUtil {
    public static final ResourceLocation CUTOUT = ResourceLocation.withDefaultNamespace((String)"cutout");
    private static String mc = "minecraft:";
    public static String TOOL = mc + "item/handheld";
    public static String ITEM = mc + "item/generated";
    private static String mod = "synergy:";

    @Deprecated
    public static Block getBlock(String id) {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"synergy", (String)id));
    }

    @Deprecated
    public static Block getBlock(String id, String modid) {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)modid, (String)id));
    }

    @Deprecated
    public static String getPath(Block b) {
        return BuiltInRegistries.BLOCK.getKey((Object)b).getPath();
    }

    @Deprecated
    public static String getPath(Item i) {
        return BuiltInRegistries.ITEM.getKey((Object)i).getPath();
    }

    @Deprecated
    public static ResourceLocation getResource(String s) {
        return ResourceLocation.fromNamespaceAndPath((String)"synergy", (String)s);
    }

    @Deprecated
    public static ResourceLocation getResource(Block b) {
        return ResourceLocation.fromNamespaceAndPath((String)"synergy", (String)DataGenUtil.getPath(b));
    }

    @Deprecated
    public static ResourceLocation getResource(Item i) {
        return ResourceLocation.fromNamespaceAndPath((String)"synergy", (String)DataGenUtil.getPath(i));
    }

    public static ItemModelBuilder itemTool(Item item, ItemModelProvider b) {
        return (ItemModelBuilder)((ItemModelBuilder)b.withExistingParent(DataGenUtil.getPath(item), TOOL)).texture("layer0", DataGenUtil.getResource("item/" + DataGenUtil.getPath(item)));
    }

    public static ItemModelBuilder itemModel(Item item, ItemModelProvider b) {
        return (ItemModelBuilder)((ItemModelBuilder)b.withExistingParent(DataGenUtil.getPath(item), ITEM)).texture("layer0", DataGenUtil.getResource("item/" + DataGenUtil.getPath(item)));
    }

    public static ItemModelBuilder itemModel(Item item, ItemModelProvider b, String pathSuffix) {
        return (ItemModelBuilder)((ItemModelBuilder)b.withExistingParent(DataGenUtil.getPath(item), ITEM)).texture("layer0", DataGenUtil.getResource("item/" + pathSuffix + DataGenUtil.getPath(item)));
    }

    public static ItemModelBuilder itemModel(Item item, ItemModelProvider b, String pathSuffix, String itemPath) {
        return (ItemModelBuilder)((ItemModelBuilder)b.withExistingParent(DataGenUtil.getPath(item), ITEM)).texture("layer0", DataGenUtil.getResource("item/" + pathSuffix + itemPath));
    }

    public static ItemModelBuilder itemBlock(Block block, ItemModelProvider b) {
        return (ItemModelBuilder)b.withExistingParent(DataGenUtil.getPath(block), mod + "block/" + DataGenUtil.getPath(block));
    }

    public static BlockModelBuilder cross(BlockStateProvider t, String filePath, ResourceLocation texturePath) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)t.models().withExistingParent(filePath, t.mcLoc("block/cross"))).texture("cross", texturePath)).renderType("minecraft:cutout");
    }

    public static BlockModelBuilder crop(BlockStateProvider t, String filePath, ResourceLocation texturePath) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)t.models().withExistingParent(filePath, t.mcLoc("block/crop"))).texture("crop", texturePath)).renderType("minecraft:cutout");
    }

    public static BlockModelBuilder crossORcrop(BlockStateProvider t, boolean isCrop, String filePath, ResourceLocation texturePath) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)t.models().withExistingParent(filePath, t.mcLoc("block/" + (isCrop ? "crop" : "cross")))).texture(isCrop ? "crop" : "cross", texturePath)).renderType("minecraft:cutout");
    }

    public static BlockModelBuilder BlockwithParent(Block block, BlockStateProvider b, String parent) {
        return (BlockModelBuilder)b.models().withExistingParent(DataGenUtil.getPath(block), parent);
    }

    public static void BiStateBlock(BlockStateProvider t, Block b, BooleanProperty p, ModelFile on, ModelFile off) {
        ((VariantBlockStateBuilder)t.getVariantBuilder(b).partialState().with((Property)p, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(on).addModel()).partialState().with((Property)p, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(off).addModel();
    }

    public static ItemModelBuilder itemBlockwithParent(Block block, ItemModelProvider b, String parent) {
        return (ItemModelBuilder)b.withExistingParent(DataGenUtil.getPath(block), parent);
    }

    public static LootItemBlockStatePropertyCondition.Builder lootTableCondition(Block block, IntegerProperty prop, int age_limit) {
        return LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)prop, age_limit));
    }

    public static LootItemBlockStatePropertyCondition.Builder lootTableCondition(Block block, BooleanProperty prop) {
        return LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)prop, true));
    }

    public static LootItemBlockStatePropertyCondition.Builder lootTableConditionInverse(Block block, BooleanProperty prop) {
        return LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)prop, false));
    }

    public static void modifyLootTables(DataGlobalLootModifier g, String lootModifier, String ... lootTables) {
        g.add(lootModifier, (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{AnyOfCondition.anyOf((LootItemCondition.Builder[])((LootItemCondition.Builder[])Arrays.asList(lootTables).stream().map(r -> LootTableIdCondition.builder((ResourceLocation)ResourceLocation.parse((String)r))).toArray(LootTableIdCondition.Builder[]::new))).build()}, ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)DataGenUtil.modLoc(lootModifier))), new ICondition[0]);
    }

    public static void modifyLootTables(DataGlobalLootModifier g, String lootModifier, ResourceKey<LootTable> ... lootTables) {
        DataGenUtil.modifyLootTables(g, lootModifier, (String[])Arrays.asList(lootTables).stream().map(r -> r.location().getPath()).toArray(String[]::new));
    }

    public static void modifyLootTables(DataGlobalLootModifier g, String lootModifier, EntityType<?> ... lootTables) {
        DataGenUtil.modifyLootTables(g, lootModifier, (String[])Arrays.asList(lootTables).stream().map(r -> r.getDefaultLootTable().location().getPath()).toArray(String[]::new));
    }

    public static void modifyLootTables(DataGlobalLootModifier g, String lootModifier, ResourceKey<LootTable>[] chestTables, EntityType<?> ... entityTables) {
        DataGenUtil.modifyLootTables(g, lootModifier, ArrayUtils.concat((String[])Arrays.asList(entityTables).stream().map(r -> r.getDefaultLootTable().location().getPath()).toArray(String[]::new), (String[])Arrays.asList(chestTables).stream().map(r -> r.location().getPath()).toArray(String[]::new)));
    }

    @Deprecated
    public static ResourceLocation modLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"synergy", (String)path);
    }

    public static LootPool.Builder createPool() {
        return LootPool.lootPool();
    }

    public static LootTable.Builder createTable(LootPool.Builder pool) {
        return LootTable.lootTable().withPool(pool).setParamSet(LootContextParamSet.builder().build());
    }

    public static void registerTable(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> c, ResourceLocation tableLocation, LootTable.Builder table) {
        c.accept((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)tableLocation), table);
    }

    public static Item[] getItems(DeferredRegister<?> register) {
        return (Item[])register.getEntries().stream().map(DeferredHolder::get).flatMap(i -> {
            if (i instanceof Item) {
                Item item = (Item)i;
                return Stream.of(item);
            }
            if (i instanceof Block) {
                Block block = (Block)i;
                Item item = (Item)Item.BY_BLOCK.get(block);
                return item != null ? Stream.of(item) : Stream.empty();
            }
            return Stream.empty();
        }).toArray(Item[]::new);
    }
}

