/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.utils;

import com.devdyna.synergy.api.zFluid;
import com.devdyna.synergy.init.types.zFluids;
import com.devdyna.synergy.init.types.zItems;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ClazzUtil {
    public static List<DeferredHolder<Item, ?>> getAllzItems() {
        ArrayList items = new ArrayList();
        for (Field field : zItems.class.getDeclaredFields()) {
            try {
                DeferredHolder holder;
                Object value;
                if (!DeferredHolder.class.isAssignableFrom(field.getType()) || !((value = field.get(null)) instanceof DeferredHolder) || !((holder = (DeferredHolder)value).value() instanceof Item)) continue;
                DeferredHolder itemHolder = holder;
                items.add(itemHolder);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return items;
    }

    public static List<DeferredHolder<Block, ?>> getAllzBlocks() {
        ArrayList blocks = new ArrayList();
        for (Field field : zItems.class.getDeclaredFields()) {
            try {
                DeferredHolder holder;
                Object value;
                if (!DeferredHolder.class.isAssignableFrom(field.getType()) || !((value = field.get(null)) instanceof DeferredHolder) || !((holder = (DeferredHolder)value).value() instanceof Block)) continue;
                DeferredHolder blockHolder = holder;
                blocks.add(blockHolder);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return blocks;
    }

    public static List<zFluid> getAllzFluids() {
        ArrayList<zFluid> l = new ArrayList<zFluid>();
        for (Field field : zFluids.class.getDeclaredFields()) {
            try {
                Object value;
                if (!zFluid.class.isAssignableFrom(field.getType()) || !((value = field.get(null)) instanceof zFluid)) continue;
                zFluid f = (zFluid)value;
                l.add(f);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return l;
    }

    public static String[] getAllStrings(Class<?> clazz) {
        try {
            Field[] fields = clazz.getDeclaredFields();
            return (String[])Arrays.stream(fields).filter(f -> f.getType() == String.class).map(f -> {
                try {
                    f.setAccessible(true);
                    return (String)f.get(null);
                }
                catch (Exception e) {
                    return null;
                }
            }).filter(s -> s != null).toArray(String[]::new);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public static List<DeferredHolder<Item, ?>> getAllzItemsFiltered(DeferredRegister.Blocks ... blacklist) {
        List<DeferredHolder<Item, ?>> allItems = ClazzUtil.getAllzItems();
        Set filteredBlocks = Arrays.stream(blacklist).flatMap(reg -> reg.getEntries().stream()).map(holder -> (Block)holder.get()).collect(Collectors.toSet());
        return allItems.stream().filter(itemHolder -> {
            BlockItem bi;
            Item item = (Item)itemHolder.get();
            return !(item instanceof BlockItem) || !filteredBlocks.contains((bi = (BlockItem)item).getBlock());
        }).collect(Collectors.toList());
    }
}

