/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.recipeTypes.type;

import com.devdyna.synergy.init.recipeTypes.input.ItemListInput;
import com.devdyna.synergy.init.types.zBlocks;
import com.devdyna.synergy.init.types.zRecipeTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class UrnRitualRecipe
implements Recipe<ItemListInput> {
    public static final int INPUT_COUNT = 9;
    public final NonNullList<Ingredient> inputs;
    public final ItemStack output;

    public UrnRitualRecipe(List<Ingredient> inputs, ItemStack output) {
        this.inputs = NonNullList.copyOf(inputs);
        this.output = output;
    }

    public static UrnRitualRecipe of(NonNullList<Ingredient> inputs, ItemStack output) {
        return new UrnRitualRecipe((List<Ingredient>)inputs, output);
    }

    public static UrnRitualRecipe of(ItemStack output, Ingredient ... inputs) {
        return new UrnRitualRecipe(Arrays.asList(inputs), output);
    }

    public boolean matches(ItemListInput r, Level l) {
        ArrayList<ItemStack> temp = new ArrayList<ItemStack>();
        if (r.size() < temp.size()) {
            return false;
        }
        for (int j = 0; j < r.size(); ++j) {
            try {
                ItemStack item = r.getItem(j);
                if (item.isEmpty()) continue;
                temp.add(item);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return temp.size() == this.inputs.size() && RecipeMatcher.findMatches(temp, this.inputs) != null;
    }

    public ItemStack assemble(ItemListInput i, HolderLookup.Provider r) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int xz, int y) {
        return false;
    }

    public RecipeType<?> getType() {
        return zRecipeTypes.URN_RITUAL_RECIPE.getType();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)zBlocks.URN.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return zRecipeTypes.URN_RITUAL_RECIPE.getSerializer();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public ItemStack getResultItem() {
        return this.output;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.output;
    }
}

