/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.recipeTypes.type;

import com.devdyna.synergy.init.recipeTypes.input.MonoItemInput;
import com.devdyna.synergy.init.types.zBlocks;
import com.devdyna.synergy.init.types.zRecipeTypes;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class QuernMillingRecipe
implements Recipe<MonoItemInput> {
    private final Ingredient input;
    private final int time;
    private final ItemStack output;

    public QuernMillingRecipe(Ingredient input, ItemStack output, int time) {
        this.input = input;
        this.time = time;
        this.output = output;
    }

    public static QuernMillingRecipe of(Ingredient input, ItemStack output, int time) {
        return new QuernMillingRecipe(input, output, time);
    }

    public boolean matches(MonoItemInput r, Level l) {
        return this.input.test(r.input());
    }

    public ItemStack assemble(MonoItemInput i, HolderLookup.Provider r) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int xz, int y) {
        return false;
    }

    public RecipeType<?> getType() {
        return zRecipeTypes.QUERN_MILLING.getType();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)zBlocks.QUERN.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return zRecipeTypes.QUERN_MILLING.getSerializer();
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.copyOf(List.of(this.input));
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getTime() {
        return this.time;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.output;
    }
}

