/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.recipeTypes.type;

import com.devdyna.synergy.init.recipeTypes.input.UseItemInput;
import com.devdyna.synergy.init.types.zRecipeTypes;
import com.devdyna.synergy.utils.x;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ItemUseRecipe
implements Recipe<UseItemInput> {
    private final Ingredient inputItem;
    private final BlockState inputState;
    private final BlockState outputState;
    private final boolean canBeDisabled;

    public ItemUseRecipe(Ingredient inputItem, BlockState inputState, BlockState outputState, boolean canBeDisabled) {
        this.inputItem = inputItem;
        this.inputState = inputState;
        this.outputState = outputState;
        this.canBeDisabled = canBeDisabled;
    }

    public boolean matches(UseItemInput r, Level l) {
        return this.inputItem.test(r.input()) && this.inputState.is(r.block().getBlock()) && !this.canBeDisabled;
    }

    public ItemStack assemble(UseItemInput i, HolderLookup.Provider r) {
        return x.item((ItemLike)this.outputState.getBlock());
    }

    public boolean canCraftInDimensions(int xz, int y) {
        return false;
    }

    public RecipeType<?> getType() {
        return zRecipeTypes.ITEM_USE.getType();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)Items.WOODEN_PICKAXE);
    }

    public RecipeSerializer<?> getSerializer() {
        return zRecipeTypes.ITEM_USE.getSerializer();
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.copyOf(List.of(x.ingredient(this.inputState.getBlock().asItem()), this.inputItem));
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return x.item((ItemLike)this.outputState.getBlock());
    }

    public Ingredient getInputItem() {
        return this.inputItem;
    }

    public BlockState getInputState() {
        return this.inputState;
    }

    public BlockState getOutputState() {
        return this.outputState;
    }

    public boolean canBeDisabled() {
        return this.canBeDisabled;
    }
}

